/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.core.security;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.SecurityContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.security.DefaultMuleCredentials;
import org.mule.runtime.core.api.security.EncryptionStrategy;
import org.mule.test.IntegrationTestCaseRunnerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class MultiuserSecurityTestCase
extends MuleArtifactFunctionalTestCase
implements IntegrationTestCaseRunnerConfig {
    protected String[] getConfigFiles() {
        return new String[]{"org/mule/test/core/multiuser-security-test-flow.xml", "org/mule/test/core/singleuser-security-provider.xml"};
    }

    @Test
    public void testMultipleAuthentications() throws Exception {
        Message reply = this.getResponse("Data1", "marie");
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)"user = marie, logins = 1, color = bright red", (Object)reply.getPayload().getValue());
        reply = this.getResponse("Data2", "stan");
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)"user = stan, logins = 1, color = metallic blue", (Object)reply.getPayload().getValue());
        reply = this.getResponse("Data3", "cindy");
        Assert.assertEquals((Object)"user = cindy, logins = 1, color = dark violet", (Object)reply.getPayload().getValue());
        reply = this.getResponse("Data4", "marie");
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)"user = marie, logins = 2, color = bright red", (Object)reply.getPayload().getValue());
        reply = this.getResponse("Data4", "marie");
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)"user = marie, logins = 3, color = bright red", (Object)reply.getPayload().getValue());
        reply = this.getResponse("Data2", "stan");
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)"user = stan, logins = 2, color = metallic blue", (Object)reply.getPayload().getValue());
    }

    public Message getResponse(String data, String user) throws Exception {
        EncryptionStrategy strategy = muleContext.getSecurityManager().getEncryptionStrategy("PBE");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("MULE_USER", DefaultMuleCredentials.createHeader((String)user, (String)user, (String)"PBE", (EncryptionStrategy)strategy));
        return ((FlowRunner)((FlowRunner)this.flowRunner("testService").withPayload((Object)data)).withInboundProperties(props)).run().getMessage();
    }

    public static class TestSecurityProcessor
    extends AbstractComponent
    implements Processor {
        protected static final Logger logger = LoggerFactory.getLogger(TestSecurityProcessor.class);

        public CoreEvent process(CoreEvent event) throws MuleException {
            SecurityContext securityContext = event.getSecurityContext();
            Authentication authentication = securityContext.getAuthentication();
            int numberLogins = (Integer)authentication.getProperties().get("NUMBER_LOGINS");
            String favoriteColor = (String)authentication.getProperties().get("FAVORITE_COLOR");
            String msg = "user = " + authentication.getPrincipal() + ", logins = " + numberLogins + ", color = " + favoriteColor;
            logger.debug(msg);
            return CoreEvent.builder((CoreEvent)event).message(Message.builder((Message)event.getMessage()).value((Object)msg).build()).build();
        }
    }
}

