/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.spring.security;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.IntegrationTestCaseRunnerConfig;

public class CustomSecManagerHttpFilterFunctionalTestCase
extends MuleArtifactFunctionalTestCase
implements IntegrationTestCaseRunnerConfig {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigFile() {
        return "org/mule/test/spring/security/custom-security-manager-test.xml";
    }

    protected String getUrl() {
        return "http://localhost:" + this.dynamicPort.getValue() + "/authenticate";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthenticationFailureNoContext() throws Exception {
        HttpClient client = new HttpClient();
        client.getParams().setAuthenticationPreemptive(true);
        GetMethod get = new GetMethod(this.getUrl());
        get.setDoAuthentication(false);
        try {
            int status = client.executeMethod((HttpMethod)get);
            Assert.assertThat((Object)status, (Matcher)CoreMatchers.is((Object)401));
            Assert.assertThat((Object)get.getResponseBodyAsString(), (Matcher)CoreMatchers.containsString((String)"no security context on the session. Authentication denied on connector"));
        }
        finally {
            get.releaseConnection();
        }
    }

    @Test
    public void testAuthenticationFailureBadCredentials() throws Exception {
        this.doRequest(null, "localhost", "anonX", "anonX", this.getUrl(), false, 401);
    }

    @Ignore
    @Test
    public void testAuthenticationFailureBadRealm() throws Exception {
        this.doRequest("blah", "localhost", "anon", "anon", this.getUrl(), false, 401);
    }

    @Test
    public void testAuthenticationAuthorised() throws Exception {
        this.doRequest(null, "localhost", "anon", "anon", this.getUrl(), false, 200);
    }

    @Test
    public void testAuthenticationAuthorisedWithHandshake() throws Exception {
        this.doRequest(null, "localhost", "anon", "anon", this.getUrl(), true, 200);
    }

    @Ignore
    @Test
    public void testAuthenticationAuthorisedWithHandshakeAndBadRealm() throws Exception {
        this.doRequest("blah", "localhost", "anon", "anon", this.getUrl(), true, 401);
    }

    @Test
    public void testAuthenticationAuthorisedWithHandshakeAndRealm() throws Exception {
        this.doRequest("mule-realm", "localhost", "ross", "ross", this.getUrl(), true, 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequest(String realm, String host, String user, String pass, String url, boolean handshake, int result) throws Exception {
        HttpClient client = new HttpClient();
        client.getParams().setAuthenticationPreemptive(true);
        client.getState().setCredentials(new AuthScope(host, -1, realm), (Credentials)new UsernamePasswordCredentials(user, pass));
        GetMethod get = new GetMethod(url);
        get.setDoAuthentication(handshake);
        try {
            int status = client.executeMethod((HttpMethod)get);
            if (status == 401 && handshake) {
                status = client.executeMethod((HttpMethod)get);
            }
            Assert.assertEquals((long)result, (long)status);
        }
        finally {
            get.releaseConnection();
        }
    }
}

