/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.oauth;

import java.time.ZonedDateTime;
import javax.inject.Inject;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.extension.api.runtime.parameter.Literal;
import org.mule.test.oauth.ConnectionType;
import org.mule.test.values.extension.MyPojo;

public class ConnectionProperties {
    @Inject
    private ExtensionManager extensionManager = null;
    private String connectionDescription;
    private ConnectionType connectionType;
    private Literal<String> connectionPropertyGrade;
    private ZonedDateTime connectionTime;
    private MyPojo importedPojo;

    public ConnectionProperties() {
    }

    public ConnectionProperties(String connectionDescription, ConnectionType connectionType, Literal<String> connectionPropertyGrade, ZonedDateTime connectionTime, MyPojo importedPojo) {
        this.connectionDescription = connectionDescription;
        this.connectionType = connectionType;
        this.connectionPropertyGrade = connectionPropertyGrade;
        this.connectionTime = connectionTime;
        this.importedPojo = importedPojo;
    }

    public Literal<String> getConnectionPropertyGrade() {
        return this.connectionPropertyGrade;
    }

    public String getConnectionDescription() {
        return this.connectionDescription;
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public ZonedDateTime getConnectionTime() {
        return this.connectionTime;
    }

    public MyPojo getImportedPojo() {
        return this.importedPojo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionProperties that = (ConnectionProperties)o;
        if (this.connectionDescription != null ? !this.connectionDescription.equals(that.connectionDescription) : that.connectionDescription != null) {
            return false;
        }
        if (this.connectionType != that.connectionType) {
            return false;
        }
        if (this.connectionPropertyGrade != null && that.connectionPropertyGrade != null ? !this.connectionPropertyGrade.getLiteralValue().equals(that.connectionPropertyGrade.getLiteralValue()) : this.connectionPropertyGrade != that.connectionPropertyGrade) {
            return false;
        }
        if (this.importedPojo != null ? !this.importedPojo.equals((Object)that.importedPojo) : that.importedPojo != null) {
            return false;
        }
        return this.connectionTime != null ? this.connectionTime.equals(that.connectionTime) : that.connectionTime == null;
    }

    public int hashCode() {
        int result = this.connectionDescription != null ? this.connectionDescription.hashCode() : 0;
        result = 31 * result + (this.connectionType != null ? this.connectionType.hashCode() : 0);
        result = 31 * result + (this.connectionPropertyGrade != null ? this.connectionPropertyGrade.getLiteralValue().orElse("").hashCode() : 0);
        result = 31 * result + (this.connectionTime != null ? this.connectionTime.hashCode() : 0);
        return result;
    }
}

