/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.oauth.metadata;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.AttributesTypeResolver;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.QueryEntityResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.test.oauth.TestOAuthConnection;

public class RefreshedOAuthMetadataResolver
implements OutputTypeResolver<String>,
AttributesTypeResolver<String>,
InputTypeResolver<String>,
TypeKeysResolver,
QueryEntityResolver {
    public Set<MetadataKey> getKeys(MetadataContext context) throws MetadataResolvingException, ConnectionException {
        this.checkIfTokenIsRefreshed(context);
        return new HashSet<MetadataKey>(Arrays.asList(MetadataKeyBuilder.newKey((String)"anyKey").build()));
    }

    public String getResolverName() {
        return "Metadata resolver";
    }

    public Set<MetadataKey> getEntityKeys(MetadataContext context) throws MetadataResolvingException, ConnectionException {
        this.checkIfTokenIsRefreshed(context);
        return new HashSet<MetadataKey>(Arrays.asList(MetadataKeyBuilder.newKey((String)"anyKey").build()));
    }

    public MetadataType getEntityMetadata(MetadataContext context, String key) throws MetadataResolvingException, ConnectionException {
        this.checkIfTokenIsRefreshed(context);
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build();
    }

    public MetadataType getInputMetadata(MetadataContext context, String key) throws MetadataResolvingException, ConnectionException {
        this.checkIfTokenIsRefreshed(context);
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build();
    }

    public MetadataType getAttributesType(MetadataContext context, String key) throws MetadataResolvingException, ConnectionException {
        this.checkIfTokenIsRefreshed(context);
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build();
    }

    public MetadataType getOutputType(MetadataContext context, String key) throws MetadataResolvingException, ConnectionException {
        this.checkIfTokenIsRefreshed(context);
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build();
    }

    private void checkIfTokenIsRefreshed(MetadataContext context) throws ConnectionException {
        TestOAuthConnection testOAuthConnection = (TestOAuthConnection)context.getConnection().get();
        if (!testOAuthConnection.getState().getState().getAccessToken().contains("refreshed")) {
            throw new AccessTokenExpiredException();
        }
    }

    public String getCategoryName() {
        return "OAuth Category";
    }
}

