/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.rules.TemporaryFolder;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.module.artifact.activation.internal.classloader.DefaultArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.internal.nativelib.DefaultNativeLibraryFinderFactory;
import org.mule.runtime.module.artifact.activation.internal.nativelib.NativeLibraryFinderFactory;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.openjdk.jmh.annotations.TearDown;

public abstract class AbstractArtifactActivationBenchmark
extends AbstractMuleTestCase {
    protected static final String MULE_DOMAIN_FOLDER = "domains";
    protected static final String GROUP_ID = "org.mule.test";
    protected static final String PLUGIN_ID1 = "plugin1";
    protected static final String PLUGIN_ID2 = "plugin2";
    protected static final BundleDescriptor PLUGIN1_BUNDLE_DESCRIPTOR = new BundleDescriptor.Builder().setGroupId("org.mule.test").setArtifactId("plugin1").setVersion("1.0").setClassifier("mule-plugin").build();
    protected static final BundleDescriptor PLUGIN2_BUNDLE_DESCRIPTOR = new BundleDescriptor.Builder().setGroupId("org.mule.test").setArtifactId("plugin2").setVersion("1.0").setClassifier("mule-plugin").build();
    protected DomainDescriptor customDomainDescriptor;
    protected File muleHomeFolder;
    protected TemporaryFolder artifactLocation;
    protected DefaultArtifactClassLoaderResolver artifactClassLoaderResolver;
    protected final ModuleRepository moduleRepository = new DummyModuleRepository(Collections.emptyList());
    protected final DefaultNativeLibraryFinderFactory nativeLibraryFinderFactory = new DefaultNativeLibraryFinderFactory();
    protected final ArtifactPluginDescriptor plugin1Descriptor = new ArtifactPluginDescriptor("plugin1");
    protected final ArtifactPluginDescriptor plugin2Descriptor = new ArtifactPluginDescriptor("plugin2");
    protected DefaultArtifactClassLoaderResolver artifactClassLoaderResolverWithModules;

    public void setup() throws IOException {
        TemporaryFolder temporaryFolder = new TemporaryFolder();
        this.artifactLocation = new TemporaryFolder();
        temporaryFolder.create();
        this.artifactLocation.create();
        this.muleHomeFolder = temporaryFolder.getRoot();
        System.setProperty("mule.home", temporaryFolder.getRoot().getAbsolutePath());
        this.artifactClassLoaderResolver = new DefaultArtifactClassLoaderResolver(this.moduleRepository, (NativeLibraryFinderFactory)this.nativeLibraryFinderFactory);
        this.plugin1Descriptor.setBundleDescriptor(PLUGIN1_BUNDLE_DESCRIPTOR);
        this.plugin2Descriptor.setBundleDescriptor(PLUGIN2_BUNDLE_DESCRIPTOR);
    }

    @TearDown
    public void tearDown() {
        this.deleteIfNeeded(MuleFoldersUtil.getDomainsFolder());
        this.deleteIfNeeded(new File(MuleFoldersUtil.getMuleLibFolder(), "shared"));
        System.clearProperty("mule.home");
    }

    protected void deleteIfNeeded(File file) {
        if (file.exists()) {
            FileUtils.deleteQuietly((File)file);
        }
    }

    protected DomainDescriptor getTestDomainDescriptor(String name) {
        DomainDescriptor descriptor = new DomainDescriptor(name);
        descriptor.setRedeploymentEnabled(false);
        descriptor.setArtifactLocation(this.artifactLocation.getRoot());
        return descriptor;
    }

    protected File createDomainDir(String domainFolder, String domain) {
        File file = new File(this.muleHomeFolder, domainFolder + File.separator + domain);
        MatcherAssert.assertThat((Object)file.mkdirs(), (Matcher)Is.is((Object)true));
        return file;
    }

    protected MuleDeployableArtifactClassLoader getTestDomainClassLoader(List<ArtifactPluginDescriptor> plugins) {
        this.customDomainDescriptor.setPlugins(new HashSet<ArtifactPluginDescriptor>(plugins));
        return this.artifactClassLoaderResolver.createDomainClassLoader(this.customDomainDescriptor);
    }

    public static class DummyModuleRepository
    implements ModuleRepository {
        private final List<MuleModule> muleModules;

        public DummyModuleRepository(List<MuleModule> muleModules) {
            this.muleModules = muleModules;
        }

        public List<MuleModule> getModules() {
            return this.muleModules;
        }
    }
}

