/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.container.api.ContainerClassLoaderProvider;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.module.artifact.activation.internal.classloader.DefaultArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.internal.nativelib.NativeLibraryFinderFactory;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.mule.test.AbstractArtifactActivationBenchmark;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

@Fork(value=1)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Benchmark)
public class DomainClassloaderCreationBenchmark
extends AbstractArtifactActivationBenchmark {
    private DomainDescriptor defaultDomainDescriptor;
    private final String customDomainName = "custom-domain";
    private final String onlyDomainPackageName = "domain-package";
    private final String repeatedPackageName = "module&domain-package";
    private Set<ArtifactPluginDescriptor> artifactPluginDescriptors;
    private ClassLoaderModel classLoaderModel;
    private MuleDeployableArtifactClassLoader domainClassLoaderForCache;
    private DomainDescriptor newDomainDescriptorForCache;
    private MuleArtifactClassLoader plugin2ClassLoaderForCache;
    private MuleModule muleModule;
    private List<MuleModule> muleModuleSingletonList;

    @Override
    @Setup
    public void setup() throws IOException {
        super.setup();
        this.defaultDomainDescriptor = this.getTestDomainDescriptor("default");
        this.customDomainDescriptor = this.getTestDomainDescriptor("custom-domain");
        this.customDomainDescriptor.setRootFolder(this.createDomainDir("domains", "custom-domain"));
        this.muleModule = new MuleModule("TEST", Collections.singleton("module&domain-package"), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptyList());
        this.muleModuleSingletonList = Collections.singletonList(this.muleModule);
        AbstractArtifactActivationBenchmark.DummyModuleRepository moduleRepositoryWithModules = new AbstractArtifactActivationBenchmark.DummyModuleRepository(this.muleModuleSingletonList);
        this.artifactClassLoaderResolverWithModules = new DefaultArtifactClassLoaderResolver(ContainerClassLoaderProvider.createContainerClassLoader((ModuleRepository)moduleRepositoryWithModules), (ModuleRepository)moduleRepositoryWithModules, (NativeLibraryFinderFactory)this.nativeLibraryFinderFactory);
        Set domainExportedPackage = Stream.of("domain-package", "module&domain-package").collect(Collectors.toSet());
        this.artifactPluginDescriptors = Stream.of(this.plugin1Descriptor, this.plugin2Descriptor).collect(Collectors.toSet());
        this.classLoaderModel = new ClassLoaderModel.ClassLoaderModelBuilder().exportingPackages(domainExportedPackage).build();
        this.domainClassLoaderForCache = this.artifactClassLoaderResolver.createDomainClassLoader(this.customDomainDescriptor);
        this.newDomainDescriptorForCache = (DomainDescriptor)this.domainClassLoaderForCache.getArtifactDescriptor();
        this.newDomainDescriptorForCache.setPlugins(this.artifactPluginDescriptors);
        this.plugin2ClassLoaderForCache = this.artifactClassLoaderResolver.createMulePluginClassLoader(this.domainClassLoaderForCache, this.plugin2Descriptor, (apds, d) -> Optional.empty());
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public MuleDeployableArtifactClassLoader createDomainDefaultClassLoader() {
        return this.artifactClassLoaderResolver.createDomainClassLoader(this.defaultDomainDescriptor);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public MuleDeployableArtifactClassLoader createDomainClassLoaderWithExportedPackages() {
        this.customDomainDescriptor.setClassLoaderModel(this.classLoaderModel);
        return this.artifactClassLoaderResolverWithModules.createDomainClassLoader(this.customDomainDescriptor);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public MuleDeployableArtifactClassLoader createDomainClassLoaderWithPlugins() {
        this.customDomainDescriptor.setPlugins(this.artifactPluginDescriptors);
        return this.artifactClassLoaderResolver.createDomainClassLoader(this.customDomainDescriptor);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public MuleDeployableArtifactClassLoader createDomainClassLoaderWithCachedPlugin() {
        return this.artifactClassLoaderResolver.createDomainClassLoader(this.newDomainDescriptorForCache, (ownerClassLoader, pluginDescriptor) -> {
            if (pluginDescriptor.getBundleDescriptor().getArtifactId().equals(this.plugin2Descriptor.getBundleDescriptor().getArtifactId())) {
                return Optional.of(() -> this.plugin2ClassLoaderForCache);
            }
            return Optional.empty();
        });
    }
}

