/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.container.api.ContainerClassLoaderProvider;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.module.artifact.activation.internal.classloader.DefaultArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.internal.nativelib.DefaultNativeLibraryFinderFactory;
import org.mule.runtime.module.artifact.activation.internal.nativelib.NativeLibraryFinderFactory;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleScope;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.mule.test.AbstractArtifactActivationBenchmark;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

@Fork(value=1)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Benchmark)
public class PluginClassloaderCreationBenchmark
extends AbstractArtifactActivationBenchmark {
    public static final String MULE_DOMAIN_FOLDER = "domains";
    private static final String PRIVILEGED_PACKAGE = "org.foo.privileged";
    private static final String PLUGIN_ARTIFACT_ID1 = "org.mule.test:plugin1";
    private final ArtifactPluginDescriptor plugin2DescriptorWithPrivilege = new ArtifactPluginDescriptor("plugin2");
    private final DefaultNativeLibraryFinderFactory nativeLibraryFinderFactory = new DefaultNativeLibraryFinderFactory();
    private final String customDomainName = "custom-domain";
    private final String applicationName = "app";
    private final String pluginPackage = "plugin-package";
    private final String plugin2ExportedPackage = "plugin2-package";
    private final String package1Name = "module&plugin-package";
    private final String package2Name = "org.mule.sdk.api.package";
    private MuleDeployableArtifactClassLoader applicationClassLoader;
    private ClassLoaderConfiguration pluginDependantClassLoaderConfiguration;
    private ClassLoaderConfiguration pluginExportingPackageClassLoaderConfiguration;
    private ClassLoaderConfiguration plugin2ExportingPackageClassLoaderConfiguration;
    private List<MuleModule> privilegeMuleModuleSingletonList;
    private ClassLoaderConfiguration pluginDependantWithLocalPackageClassLoaderConfiguration;
    private ClassLoaderConfiguration pluginWithLocalPackageClassLoaderConfiguration;
    private MuleModule muleModule;
    private List<MuleModule> muleModuleSingletonList;
    private DefaultArtifactClassLoaderResolver artifactClassLoaderResolverForPrivilegedContainerAccess;
    private ModuleRepository moduleRepositoryForPrivilegedContainerAccess;

    @Override
    @Setup
    public void setup() throws IOException {
        super.setup();
        this.customDomainDescriptor = this.getTestDomainDescriptor("custom-domain");
        this.customDomainDescriptor.setRootFolder(this.createDomainDir(MULE_DOMAIN_FOLDER, "custom-domain"));
        MuleModule privilegedModule = new MuleModule("TEST", Collections.emptySet(), Collections.emptySet(), Collections.singleton(PRIVILEGED_PACKAGE), Collections.singleton(PLUGIN_ARTIFACT_ID1), Collections.emptyList());
        this.privilegeMuleModuleSingletonList = Collections.singletonList(privilegedModule);
        ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor("app");
        applicationDescriptor.setArtifactLocation(new File(this.muleHomeFolder, "app"));
        this.applicationClassLoader = this.getTestApplicationClassLoader(Collections.emptyList());
        BundleDependency pluginDependency = new BundleDependency.Builder().setScope(BundleScope.COMPILE).setDescriptor(PLUGIN2_BUNDLE_DESCRIPTOR).setBundleUri(new File("test").toURI()).build();
        this.pluginDependantClassLoaderConfiguration = new ClassLoaderConfiguration.ClassLoaderConfigurationBuilder().dependingOn(Collections.singleton(pluginDependency)).build();
        this.pluginExportingPackageClassLoaderConfiguration = new ClassLoaderConfiguration.ClassLoaderConfigurationBuilder().exportingPackages(Collections.singleton("plugin2-package")).build();
        ClassLoaderConfiguration plugin2ClassLoaderConfiguration = new ClassLoaderConfiguration.ClassLoaderConfigurationBuilder().exportingPrivilegedPackages(Collections.singleton(PRIVILEGED_PACKAGE), Collections.singleton(PLUGIN_ARTIFACT_ID1)).build();
        this.plugin2DescriptorWithPrivilege.setClassLoaderConfiguration(plugin2ClassLoaderConfiguration);
        this.plugin2ExportingPackageClassLoaderConfiguration = new ClassLoaderConfiguration.ClassLoaderConfigurationBuilder().exportingPackages(Collections.singleton("plugin-package")).build();
        this.pluginDependantWithLocalPackageClassLoaderConfiguration = new ClassLoaderConfiguration.ClassLoaderConfigurationBuilder().withLocalPackages(Collections.singleton("plugin-package")).dependingOn(Collections.singleton(pluginDependency)).build();
        this.muleModule = new MuleModule("TEST", Stream.of("module&plugin-package", "org.mule.sdk.api.package").collect(Collectors.toSet()), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptyList());
        this.muleModuleSingletonList = Collections.singletonList(this.muleModule);
        AbstractArtifactActivationBenchmark.DummyModuleRepository moduleRepositoryWithModules = new AbstractArtifactActivationBenchmark.DummyModuleRepository(this.muleModuleSingletonList);
        this.artifactClassLoaderResolverWithModules = new DefaultArtifactClassLoaderResolver(ContainerClassLoaderProvider.createContainerClassLoader((ModuleRepository)moduleRepositoryWithModules), (ModuleRepository)moduleRepositoryWithModules, (NativeLibraryFinderFactory)this.nativeLibraryFinderFactory);
        this.pluginWithLocalPackageClassLoaderConfiguration = new ClassLoaderConfiguration.ClassLoaderConfigurationBuilder().withLocalPackages(Stream.of("module&plugin-package", "org.mule.sdk.api.package").collect(Collectors.toSet())).build();
        this.moduleRepositoryForPrivilegedContainerAccess = new AbstractArtifactActivationBenchmark.DummyModuleRepository(this.privilegeMuleModuleSingletonList);
        this.artifactClassLoaderResolverForPrivilegedContainerAccess = new DefaultArtifactClassLoaderResolver(ContainerClassLoaderProvider.createContainerClassLoader((ModuleRepository)this.moduleRepositoryForPrivilegedContainerAccess), this.moduleRepositoryForPrivilegedContainerAccess, (NativeLibraryFinderFactory)this.nativeLibraryFinderFactory);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public MuleArtifactClassLoader createDependantPluginClassLoader() {
        this.plugin1Descriptor.setClassLoaderConfiguration(this.pluginDependantClassLoaderConfiguration);
        this.plugin2Descriptor.setClassLoaderConfiguration(this.pluginExportingPackageClassLoaderConfiguration);
        return this.artifactClassLoaderResolver.createMulePluginClassLoader(this.applicationClassLoader, this.plugin1Descriptor, (apds, d) -> Optional.of(this.plugin2Descriptor));
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public MuleArtifactClassLoader createPluginClassLoaderWithPrivilegedContainerAccess() {
        return this.artifactClassLoaderResolverForPrivilegedContainerAccess.createMulePluginClassLoader(this.applicationClassLoader, this.plugin1Descriptor, (apds, d) -> Optional.empty());
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public MuleArtifactClassLoader createsPluginClassLoaderWithPrivilegedPluginAccess() {
        this.plugin1Descriptor.setClassLoaderConfiguration(this.pluginDependantClassLoaderConfiguration);
        return this.artifactClassLoaderResolver.createMulePluginClassLoader(this.applicationClassLoader, this.plugin1Descriptor, (apds, d) -> Optional.of(this.plugin2Descriptor));
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public MuleArtifactClassLoader createPluginClassLoaderWithExportedLocalPackage() {
        this.plugin2Descriptor.setClassLoaderConfiguration(this.plugin2ExportingPackageClassLoaderConfiguration);
        this.plugin1Descriptor.setClassLoaderConfiguration(this.pluginDependantWithLocalPackageClassLoaderConfiguration);
        return this.artifactClassLoaderResolver.createMulePluginClassLoader(this.applicationClassLoader, this.plugin1Descriptor, (apds, d) -> Optional.of(this.plugin2Descriptor));
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public MuleArtifactClassLoader createPluginClassLoaderWithIgnoredLocalPackages() {
        this.plugin1Descriptor.setClassLoaderConfiguration(this.pluginWithLocalPackageClassLoaderConfiguration);
        return this.artifactClassLoaderResolverWithModules.createMulePluginClassLoader(this.applicationClassLoader, this.plugin1Descriptor, (apds, d) -> Optional.empty());
    }

    private MuleDeployableArtifactClassLoader getTestApplicationClassLoader(List<ArtifactPluginDescriptor> plugins) {
        return this.getTestApplicationClassLoader(plugins, Collections.emptySet());
    }

    private MuleDeployableArtifactClassLoader getTestApplicationClassLoader(List<ArtifactPluginDescriptor> plugins, Set<String> exportedPackages) {
        MuleDeployableArtifactClassLoader domainClassLoader = this.getTestDomainClassLoader(Collections.emptyList());
        ApplicationDescriptor descriptor = new ApplicationDescriptor("app");
        descriptor.setArtifactLocation(new File(this.muleHomeFolder, "app"));
        descriptor.setPlugins(new HashSet<ArtifactPluginDescriptor>(plugins));
        descriptor.setClassLoaderConfiguration(new ClassLoaderConfiguration.ClassLoaderConfigurationBuilder().exportingPackages(exportedPackages).build());
        return this.artifactClassLoaderResolver.createApplicationClassLoader(descriptor, () -> domainClassLoader);
    }
}

