/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.container.api.ContainerClassLoaderProvider;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.jpms.api.MuleContainerModule;
import org.mule.runtime.module.artifact.activation.internal.classloader.DefaultArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.internal.nativelib.NativeLibraryFinderFactory;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.mule.test.AbstractArtifactActivationBenchmark;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

@Fork(value=1)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Benchmark)
public class ApplicationClassloaderCreationBenchmark
extends AbstractArtifactActivationBenchmark {
    private final String customDomainName = "custom-domain";
    private final String repeatedPackageName = "module&app-package";
    private final String onlyAppPackageName = "app-package";
    private final String applicationName = "app";
    private Set<ArtifactPluginDescriptor> artifactPluginDescriptors;
    private ApplicationDescriptor applicationDescriptor;
    private MuleDeployableArtifactClassLoader customDomainClassLoader;
    private MuleDeployableArtifactClassLoader domainClassLoader;
    private ClassLoaderConfiguration classLoaderConfiguration;
    private MuleDeployableArtifactClassLoader applicationClassLoaderForCache;
    private ApplicationDescriptor newApplicationDescriptorForCache;
    private MuleArtifactClassLoader plugin2ClassLoaderForCache;
    private MuleModule muleModule;
    private List<MuleContainerModule> muleModuleSingletonList;

    @Override
    @Setup
    public void setup() throws IOException {
        super.setup();
        this.customDomainDescriptor = this.getTestDomainDescriptor("custom-domain");
        this.customDomainDescriptor.setRootFolder(this.createDomainDir("domains", "custom-domain"));
        this.muleModule = new MuleModule("TEST", Collections.singleton("module&app-package"), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptyList());
        this.muleModuleSingletonList = Collections.singletonList(this.muleModule);
        AbstractArtifactActivationBenchmark.DummyModuleRepository moduleRepositoryWithModules = new AbstractArtifactActivationBenchmark.DummyModuleRepository(this.muleModuleSingletonList);
        this.artifactClassLoaderResolverWithModules = new DefaultArtifactClassLoaderResolver(ContainerClassLoaderProvider.createContainerClassLoader((ModuleRepository)moduleRepositoryWithModules), (ModuleRepository)moduleRepositoryWithModules, (NativeLibraryFinderFactory)this.nativeLibraryFinderFactory);
        this.artifactPluginDescriptors = Stream.of(this.plugin1Descriptor, this.plugin2Descriptor).collect(Collectors.toSet());
        this.applicationDescriptor = new ApplicationDescriptor("app");
        this.applicationDescriptor.setArtifactLocation(new File(this.muleHomeFolder, "app"));
        this.customDomainClassLoader = this.artifactClassLoaderResolver.createDomainClassLoader(this.customDomainDescriptor);
        this.domainClassLoader = this.getTestDomainClassLoader(Collections.emptyList());
        Set applicationExportedPackage = Stream.of("app-package", "module&app-package").collect(Collectors.toSet());
        this.classLoaderConfiguration = new ClassLoaderConfiguration.ClassLoaderConfigurationBuilder().exportingPackages(applicationExportedPackage).build();
        this.applicationClassLoaderForCache = this.artifactClassLoaderResolver.createApplicationClassLoader(this.applicationDescriptor, () -> this.domainClassLoader);
        this.newApplicationDescriptorForCache = (ApplicationDescriptor)this.applicationClassLoaderForCache.getArtifactDescriptor();
        this.newApplicationDescriptorForCache.setPlugins(this.artifactPluginDescriptors);
        this.plugin2ClassLoaderForCache = this.artifactClassLoaderResolver.createMulePluginClassLoader(this.applicationClassLoaderForCache, this.plugin2Descriptor, (apds, d) -> Optional.empty());
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public MuleDeployableArtifactClassLoader createApplicationClassLoader() {
        return this.artifactClassLoaderResolver.createApplicationClassLoader(this.applicationDescriptor, () -> this.customDomainClassLoader);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public MuleDeployableArtifactClassLoader createApplicationClassLoaderWithExportedPackages() {
        this.applicationDescriptor.setClassLoaderConfiguration(this.classLoaderConfiguration);
        return this.artifactClassLoaderResolverWithModules.createApplicationClassLoader(this.applicationDescriptor, () -> this.domainClassLoader);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public MuleDeployableArtifactClassLoader createApplicationClassLoaderWithPlugins() {
        this.applicationDescriptor.setPlugins(this.artifactPluginDescriptors);
        return this.artifactClassLoaderResolver.createApplicationClassLoader(this.applicationDescriptor, () -> this.domainClassLoader);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public MuleDeployableArtifactClassLoader createApplicationClassLoaderWithCachedPlugin() {
        return this.artifactClassLoaderResolver.createApplicationClassLoader(this.newApplicationDescriptorForCache, () -> (MuleArtifactClassLoader)this.applicationClassLoaderForCache.getParent().getParent(), (ownerClassLoader, pluginDescriptor) -> {
            if (pluginDescriptor.getBundleDescriptor().getArtifactId().equals(this.plugin2Descriptor.getBundleDescriptor().getArtifactId())) {
                return Optional.of(() -> this.plugin2ClassLoaderForCache);
            }
            return Optional.empty();
        });
    }
}

