/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.functional;

import java.beans.ExceptionListener;
import java.util.HashMap;
import junit.framework.Assert;
import org.mule.MuleManager;
import org.mule.impl.DefaultExceptionStrategy;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.model.seda.SedaModel;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEventContext;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;

public abstract class AbstractProviderFunctionalTestCase
extends AbstractMuleTestCase {
    protected static final int NUM_MESSAGES_TO_SEND = 100;
    protected UMOConnector connector;
    protected static UMOManager manager;
    protected boolean callbackCalled = false;
    protected int callbackCount = 0;
    protected boolean transacted = false;
    private final Object callbackLock = new Object();
    protected MuleDescriptor descriptor;

    protected void doSetUp() throws Exception {
        manager = MuleManager.getInstance();
        MuleManager.getConfiguration().setSynchronous(true);
        MuleManager.getConfiguration().getPoolingProfile().setInitialisationPolicy(1);
        SedaModel model = new SedaModel();
        model.setName("main");
        manager.registerModel((UMOModel)model);
        this.callbackCalled = false;
        this.callbackCount = 0;
        this.connector = this.createConnector();
        MuleManager.getConfiguration().setServerUrl("");
        manager.start();
    }

    protected void doTearDown() throws Exception {
        if (this.connector != null) {
            this.connector.dispose();
        }
    }

    public void testSend() throws Exception {
        this.descriptor = AbstractProviderFunctionalTestCase.getTestDescriptor("testComponent", FunctionalTestComponent.class.getName());
        this.initialiseComponent((UMODescriptor)this.descriptor, this.createEventCallback());
        this.sendTestData(100);
        this.afterInitialise();
        this.receiveAndTestResults();
        AbstractProviderFunctionalTestCase.assertTrue((boolean)this.callbackCalled);
    }

    public UMOComponent initialiseComponent(UMODescriptor descriptor, EventCallback callback) throws Exception {
        descriptor.setOutboundEndpoint(this.createOutboundEndpoint());
        descriptor.setInboundEndpoint(this.createInboundEndpoint());
        HashMap<String, EventCallback> props = new HashMap<String, EventCallback>();
        props.put("eventCallback", callback);
        descriptor.setProperties(props);
        MuleManager.getInstance().registerConnector(this.connector);
        UMOComponent component = MuleManager.getInstance().lookupModel("main").registerComponent(descriptor);
        descriptor.initialise();
        return component;
    }

    protected UMOEndpoint createOutboundEndpoint() {
        if (this.getOutDest() != null) {
            return new MuleEndpoint("testOut", this.getOutDest(), this.connector, null, "sender", 0, null, null);
        }
        return null;
    }

    protected UMOEndpoint createInboundEndpoint() {
        MuleEndpoint ep = new MuleEndpoint("testIn", this.getInDest(), this.connector, null, "receiver", 0, null, null);
        ep.setSynchronous(true);
        return ep;
    }

    public static MuleDescriptor getTestDescriptor(String name, String implementation) {
        MuleDescriptor descriptor = new MuleDescriptor();
        descriptor.setExceptionListener((ExceptionListener)new DefaultExceptionStrategy());
        descriptor.setName(name);
        descriptor.setImplementation((Object)implementation);
        return descriptor;
    }

    public void afterInitialise() throws Exception {
    }

    public EventCallback createEventCallback() {
        EventCallback callback = new EventCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void eventReceived(UMOEventContext context, Object component) {
                Object object = AbstractProviderFunctionalTestCase.this.callbackLock;
                synchronized (object) {
                    AbstractProviderFunctionalTestCase.this.callbackCalled = true;
                    ++AbstractProviderFunctionalTestCase.this.callbackCount;
                }
                if (!AbstractProviderFunctionalTestCase.this.transacted) {
                    Assert.assertNull((Object)context.getCurrentTransaction());
                } else {
                    Assert.assertNotNull((Object)context.getCurrentTransaction());
                }
            }
        };
        return callback;
    }

    protected abstract void sendTestData(int var1) throws Exception;

    protected abstract void receiveAndTestResults() throws Exception;

    protected abstract UMOEndpointURI getInDest();

    protected abstract UMOEndpointURI getOutDest();

    protected abstract UMOConnector createConnector() throws Exception;
}

