/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.util.ftp;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.Ftplet;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.mule.util.IOUtils;

public class Server {
    public static final int DEFAULT_PORT = 60196;
    private FtpServer server;

    public Server(int port) throws Exception {
        this(port, null);
    }

    public Server(int port, Ftplet ftplet) throws Exception {
        FtpServerFactory serverFactory = new FtpServerFactory();
        this.setupListenerFactory(serverFactory, port);
        this.setupUserManagerFactory(serverFactory);
        this.setupFtplet(serverFactory, ftplet);
        this.server = serverFactory.createServer();
        this.server.start();
    }

    private void setupListenerFactory(FtpServerFactory serverFactory, int port) {
        ListenerFactory listenerFactory = new ListenerFactory();
        listenerFactory.setPort(port);
        listenerFactory.setIdleTimeout(60000);
        serverFactory.addListener("default", listenerFactory.createListener());
    }

    private void setupUserManagerFactory(FtpServerFactory serverFactory) throws IOException {
        PropertiesUserManagerFactory userManagerFactory = new PropertiesUserManagerFactory();
        URL usersFile = IOUtils.getResourceAsUrl((String)"users.properties", this.getClass());
        if (usersFile == null) {
            throw new IOException("users.properties file not found in the classpath");
        }
        userManagerFactory.setFile(new File(usersFile.getFile()));
        serverFactory.setUserManager(userManagerFactory.createUserManager());
    }

    private void setupFtplet(FtpServerFactory serverFactory, Ftplet ftplet) {
        if (ftplet == null) {
            return;
        }
        Map ftplets = serverFactory.getFtplets();
        ftplets.put("MuleFtplet", ftplet);
        serverFactory.setFtplets(ftplets);
    }

    public void stop() {
        this.server.stop();
    }
}

