/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.security;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.security.Authentication;
import org.mule.api.security.SecurityException;
import org.mule.security.AbstractSecurityProvider;

public class TestSingleUserSecurityProvider
extends AbstractSecurityProvider {
    public static final String PROPERTY_FAVORITE_COLOR = "FAVORITE_COLOR";
    public static final String PROPERTY_NUMBER_LOGINS = "NUMBER_LOGINS";
    private Authentication authentication;
    protected final transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public TestSingleUserSecurityProvider() {
        super("single-user-test");
    }

    public TestSingleUserSecurityProvider(String name) {
        super(name);
    }

    public Authentication authenticate(Authentication authenticationRequest) throws SecurityException {
        String user = (String)authenticationRequest.getPrincipal();
        this.logger.debug((Object)("Authenticating user: " + user));
        if (this.authentication != null) {
            Map props = this.authentication.getProperties();
            int numberLogins = (Integer)props.get(PROPERTY_NUMBER_LOGINS);
            String favoriteColor = (String)props.get(PROPERTY_FAVORITE_COLOR);
            props.put(PROPERTY_NUMBER_LOGINS, numberLogins + 1);
            this.authentication.setProperties(props);
            this.logger.info((Object)("Welcome back " + user + " (" + numberLogins + 1 + " logins), we remembered your favorite color: " + favoriteColor));
        } else {
            String favoriteColor = this.getFavoriteColor(user);
            this.logger.info((Object)("First login for user: " + user + ", favorite color is " + favoriteColor));
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put(PROPERTY_NUMBER_LOGINS, 1);
            props.put(PROPERTY_FAVORITE_COLOR, favoriteColor);
            authenticationRequest.setProperties(props);
            this.authentication = authenticationRequest;
        }
        return this.authentication;
    }

    String getFavoriteColor(String user) {
        if (user.equals("marie")) {
            return "bright red";
        }
        if (user.equals("stan")) {
            return "metallic blue";
        }
        if (user.equals("cindy")) {
            return "dark violet";
        }
        return null;
    }
}

