/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.functional;

import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.mule.DefaultMuleEvent;
import org.mule.NonBlockingVoidMuleEvent;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.NonBlockingSupported;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.ReplyToHandler;
import org.mule.execution.MessageProcessorExecutionTemplate;
import org.mule.processor.chain.ProcessorExecutorFactory;
import org.mule.tck.functional.AssertionMessageProcessor;
import org.mule.tck.functional.FlowAssert;

public class ResponseAssertionMessageProcessor
extends AssertionMessageProcessor
implements InterceptingMessageProcessor,
FlowConstructAware,
Startable,
NonBlockingSupported {
    protected String responseExpression = "#[true]";
    private int responseCount = 1;
    private boolean responseSameThread = true;
    private MessageProcessor next;
    private Thread requestThread;
    private Thread responseThread;
    private CountDownLatch responseLatch;
    private int responseInvocationCount = 0;
    private MuleEvent responseEvent;
    private boolean responseResult = true;

    @Override
    public void start() throws InitialisationException {
        super.start();
        this.expressionManager.validateExpression(this.responseExpression);
        this.responseLatch = new CountDownLatch(this.responseCount);
        FlowAssert.addAssertion(this.flowConstruct.getName(), this);
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleEvent result;
        if (event == null) {
            return null;
        }
        if (event.isAllowNonBlocking() && event.getReplyToHandler() != null) {
            final ReplyToHandler originalReplyToHandler = event.getReplyToHandler();
            event = new DefaultMuleEvent(event, new ReplyToHandler(){

                public void processReplyTo(MuleEvent event, MuleMessage returnMessage, Object replyTo) throws MuleException {
                    originalReplyToHandler.processReplyTo(ResponseAssertionMessageProcessor.this.processResponse(event), null, null);
                }

                public void processExceptionReplyTo(MessagingException exception, Object replyTo) {
                    originalReplyToHandler.processExceptionReplyTo(exception, replyTo);
                }
            });
        }
        if (!((result = this.processNext(this.processRequest(event))) instanceof NonBlockingVoidMuleEvent)) {
            return this.processResponse(result);
        }
        return result;
    }

    public MuleEvent processRequest(MuleEvent event) throws MuleException {
        this.requestThread = Thread.currentThread();
        return super.process(event);
    }

    public MuleEvent processResponse(MuleEvent event) throws MuleException {
        if (event == null || VoidMuleEvent.getInstance().equals(event)) {
            return event;
        }
        this.responseThread = Thread.currentThread();
        this.responseEvent = event;
        this.responseResult = this.responseResult && this.expressionManager.evaluateBoolean(this.responseExpression, event, false, true);
        this.increaseResponseCount();
        this.responseLatch.countDown();
        return event;
    }

    private MuleEvent processNext(MuleEvent event) throws MuleException {
        if (event != null || event instanceof VoidMuleEvent) {
            try {
                return new ProcessorExecutorFactory().createProcessorExecutor(event, Collections.singletonList(this.next), MessageProcessorExecutionTemplate.createExceptionTransformerExecutionTemplate(), false).execute();
            }
            catch (MessagingException e) {
                event.getSession().setValid(false);
                throw e;
            }
        }
        return event;
    }

    @Override
    public void verify() throws InterruptedException {
        super.verify();
        if (this.responseCountFailOrNullEvent().booleanValue()) {
            Assert.fail((String)("Flow assertion '" + this.message + "' failed. No response message received or if responseCount attribute was set then it was no matched."));
        } else if (this.responseExpressionFailed().booleanValue()) {
            Assert.fail((String)("Flow assertion '" + this.message + "' failed. Response expression " + this.expression + " evaluated false."));
        } else if (this.responseCount > 0 && this.responseSameThread && this.requestThread != this.responseThread) {
            Assert.fail((String)("Flow assertion '" + this.message + "' failed. Response thread was not same as request thread"));
        } else if (this.responseCount > 0 && !this.responseSameThread && this.requestThread == this.responseThread) {
            Assert.fail((String)("Flow assertion '" + this.message + "' failed. Response thread was same as request thread"));
        }
    }

    public Boolean responseCountFailOrNullEvent() throws InterruptedException {
        return !this.isResponseProcessesCountCorrect();
    }

    public Boolean responseExpressionFailed() {
        return !this.responseResult;
    }

    public void setListener(MessageProcessor listener) {
        this.next = listener;
    }

    private void increaseResponseCount() {
        ++this.responseInvocationCount;
    }

    public void setResponseExpression(String responseExpression) {
        this.responseExpression = responseExpression;
    }

    public void setResponseCount(int responseCount) {
        this.responseCount = responseCount;
    }

    public void setResponseSameThread(boolean responseSameThread) {
        this.responseSameThread = responseSameThread;
    }

    private synchronized boolean isResponseProcessesCountCorrect() throws InterruptedException {
        boolean countReached = this.responseLatch.await(this.timeout, TimeUnit.MILLISECONDS);
        if (this.needToMatchCount) {
            return this.responseCount == this.responseInvocationCount;
        }
        return countReached;
    }
}

