/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4;

import java.util.ArrayList;
import org.mule.DefaultMuleContext;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.context.MuleContextBuilder;
import org.mule.config.bootstrap.ArtifactType;
import org.mule.config.spring.SpringXmlDomainConfigurationBuilder;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.context.DefaultMuleContextFactory;

public class DomainContextBuilder {
    private String domainConfig;
    private MuleContextBuilder muleContextBuilder = new DefaultMuleContextBuilder(){

        protected DefaultMuleContext createDefaultMuleContext() {
            DefaultMuleContext muleContext = super.createDefaultMuleContext();
            muleContext.setArtifactType(ArtifactType.DOMAIN);
            return muleContext;
        }
    };

    public DomainContextBuilder setDomainConfig(String domainConfig) {
        this.domainConfig = domainConfig;
        return this;
    }

    public MuleContext build() throws Exception {
        ArrayList<ConfigurationBuilder> builders = new ArrayList<ConfigurationBuilder>(3);
        ConfigurationBuilder cfgBuilder = this.getDomainBuilder(this.domainConfig);
        builders.add(cfgBuilder);
        DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
        MuleContext domainContext = muleContextFactory.createMuleContext(builders, this.muleContextBuilder);
        domainContext.start();
        return domainContext;
    }

    protected ConfigurationBuilder getDomainBuilder(String configResource) throws Exception {
        return new SpringXmlDomainConfigurationBuilder(configResource);
    }
}

