/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.mule.test.infrastructure.process.MuleControllerException;

public abstract class Controller {
    protected static final String ANCHOR_SUFFIX = "-anchor.txt";
    private static final IOFileFilter ANCHOR_FILTER = FileFilterUtils.suffixFileFilter((String)"-anchor.txt");
    protected static final String STATUS = "Mule Enterprise Edition is running \\(([0-9]+)\\)\\.";
    protected static final Pattern STATUS_PATTERN = Pattern.compile("Mule Enterprise Edition is running \\(([0-9]+)\\)\\.");
    private static final int DEFAULT_TIMEOUT = 30000;
    private static final String MULE_HOME_VARIABLE = "MULE_HOME";
    private static final String DOMAIN_DEPLOY_ERROR = "Error deploying domain %s.";
    private static final String ANCHOR_DELETE_ERROR = "Could not delete anchor file [%s] when stopping Mule ESB.";
    private static final String ADD_LIBRARY_ERROR = "Error copying jar file [%s] to lib directory [%s].";
    private static final int IS_RUNNING_STATUS_CODE = 0;
    protected String muleHome;
    protected String muleBin;
    protected File domainsDir;
    protected File appsDir;
    protected File libsDir;
    protected int timeout;

    public Controller(String muleHome, int timeout) {
        this.muleHome = muleHome;
        this.muleBin = this.getMuleBin();
        this.domainsDir = new File(muleHome + "/domains");
        this.appsDir = new File(muleHome + "/apps/");
        this.libsDir = new File(muleHome + "/lib/user");
        this.timeout = timeout != 0 ? timeout : 30000;
    }

    public abstract String getMuleBin();

    public void start(String[] args) {
        int error = this.runSync("start", args);
        if (error != 0) {
            throw new MuleControllerException("The mule instance couldn't be started");
        }
    }

    public void stop(String[] args) {
        int error = this.runSync("stop", args);
        this.verify(error == 0, "The mule instance couldn't be stopped", new Object[0]);
        this.deleteAnchors();
    }

    public abstract int status(String ... var1);

    public abstract int getProcessId();

    public void restart(String[] args) {
        int error = this.runSync("restart", args);
        if (error != 0) {
            throw new MuleControllerException("The mule instance couldn't be restarted");
        }
    }

    protected int runSync(String command, String ... args) {
        Map<Object, Object> newEnv = this.copyEnvironmentVariables();
        return this.executeSyncCommand(command, args, newEnv, this.timeout);
    }

    private int executeSyncCommand(String command, String[] args, Map<Object, Object> newEnv, int timeout) throws MuleControllerException {
        CommandLine commandLine = new CommandLine(this.muleBin);
        commandLine.addArgument(command);
        commandLine.addArguments(args);
        DefaultExecutor executor = new DefaultExecutor();
        ExecuteWatchdog watchdog = new ExecuteWatchdog((long)timeout);
        executor.setWatchdog(watchdog);
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        return this.doExecution(executor, commandLine, newEnv);
    }

    protected int doExecution(DefaultExecutor executor, CommandLine commandLine, Map<Object, Object> env) {
        try {
            return executor.execute(commandLine, env);
        }
        catch (ExecuteException e) {
            return e.getExitValue();
        }
        catch (Exception e) {
            throw new MuleControllerException("Error executing [" + commandLine.getExecutable() + " " + commandLine.getArguments() + "]", e);
        }
    }

    protected Map<Object, Object> copyEnvironmentVariables() {
        Map<String, String> env = System.getenv();
        HashMap<Object, Object> newEnv = new HashMap<Object, Object>();
        for (Map.Entry<String, String> it : env.entrySet()) {
            newEnv.put(it.getKey(), it.getValue());
        }
        newEnv.put(MULE_HOME_VARIABLE, this.muleHome);
        return newEnv;
    }

    protected void verify(boolean condition, String message, Object ... args) {
        if (!condition) {
            throw new MuleControllerException(String.format(message, args));
        }
    }

    protected void deployDomain(String domain) {
        File domainFile = new File(domain);
        this.verify(domainFile.exists(), "Domain does not exist: %s", domain);
        try {
            if (domainFile.isDirectory()) {
                FileUtils.copyDirectoryToDirectory((File)domainFile, (File)this.domainsDir);
            } else {
                FileUtils.copyFileToDirectory((File)domainFile, (File)this.domainsDir);
            }
        }
        catch (IOException e) {
            throw new MuleControllerException(String.format(DOMAIN_DEPLOY_ERROR, domain), e);
        }
    }

    protected void addLibrary(File jar) {
        this.verify(jar.exists(), "Jar file does not exist: %s", jar);
        this.verify("jar".equals(FilenameUtils.getExtension((String)jar.getAbsolutePath())), "Library [%s] don't have .jar extension.", jar);
        this.verify(jar.canRead(), "Cannot read jar file: %s", jar);
        this.verify(this.libsDir.canWrite(), "Cannot write on lib dir: %", this.libsDir);
        try {
            FileUtils.copyFileToDirectory((File)jar, (File)this.libsDir);
        }
        catch (IOException e) {
            throw new MuleControllerException(String.format(ADD_LIBRARY_ERROR, jar, this.libsDir), e);
        }
    }

    protected void deleteAnchors() {
        Collection anchors = FileUtils.listFiles((File)this.appsDir, (IOFileFilter)ANCHOR_FILTER, null);
        for (File anchor : anchors) {
            try {
                FileUtils.forceDelete((File)anchor);
            }
            catch (IOException e) {
                throw new MuleControllerException(String.format(ANCHOR_DELETE_ERROR, anchor), e);
            }
        }
    }

    public void deploy(String path) {
        File app = new File(path);
        this.verify(app.exists(), "File does not exists: %s", app);
        this.verify(app.canRead(), "Cannot read file: %s", app);
        try {
            if (app.isFile()) {
                FileUtils.copyFileToDirectory((File)app, (File)this.appsDir);
            } else {
                FileUtils.copyDirectoryToDirectory((File)app, (File)this.appsDir);
            }
        }
        catch (IOException e) {
            throw new MuleControllerException("Could not deploy app [" + path + "] to [" + this.appsDir + "]", e);
        }
    }

    public boolean isRunning() {
        return 0 == this.status(new String[0]);
    }

    public void undeployAll() {
        for (File file : this.appsDir.listFiles()) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                throw new MuleControllerException("Could not delete directory [" + file.getAbsolutePath() + "]", e);
            }
        }
    }

    public void installLicense(String path) {
        this.runSync(null, "--installLicense", path);
    }

    public void uninstallLicense() {
        this.runSync(null, "-unInstallLicense");
    }

    protected boolean isDeployed(String appName) {
        return new File(this.appsDir, appName + ANCHOR_SUFFIX).exists();
    }

    public File getLog() {
        File logEE = org.mule.util.FileUtils.newFile((String)(this.muleHome + "/logs/mule_ee.log"));
        File logCE = org.mule.util.FileUtils.newFile((String)(this.muleHome + "/logs/mule.log"));
        if (logCE.exists() && logCE.isFile()) {
            return logCE;
        }
        if (logEE.exists() && logEE.isFile()) {
            return logEE;
        }
        throw new MuleControllerException(String.format("There is no mule log available at %s/logs/", this.muleHome));
    }

    public File getLog(String appName) {
        File log = org.mule.util.FileUtils.newFile((String)String.format("%s/logs/mule-app-%s.log", this.muleHome, appName));
        if (log.exists() && log.isFile()) {
            return log;
        }
        throw new MuleControllerException(String.format("There is no mule log available at %s/logs/", this.muleHome));
    }
}

