/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process.rules;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mule.test.infrastructure.process.rules.DistroUnzipper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleInstallation
extends ExternalResource {
    private static final String DISTRIBUTION_PROPERTY = "mule.distribution";
    private static final String DISTRIBUTIONS_DIR = "servers";
    private static final Path WORKING_DIRECTORY = Paths.get(System.getProperty("user.dir"), new String[0]).resolve("servers");
    private static final String DELETE_ON_EXIT = System.getProperty("mule.test.deleteOnExit");
    private static final String zippedDistributionFromProperty = System.getProperty("mule.distribution");
    private static Logger logger = LoggerFactory.getLogger(MuleInstallation.class);
    protected String location;
    private File distribution;
    private File muleHome;

    public MuleInstallation() {
        this(zippedDistributionFromProperty);
    }

    public MuleInstallation(String zippedDistribution) {
        if (StringUtils.isEmpty((String)zippedDistribution)) {
            logger.error("You must configure the location for Mule distribution in the system property: mule.distribution");
        }
        this.distribution = new File(zippedDistribution);
        if (!this.distribution.exists()) {
            throw new IllegalArgumentException("Packed distribution not found: " + this.distribution);
        }
    }

    public String getMuleHome() {
        return this.muleHome.getAbsolutePath();
    }

    public Statement apply(Statement base, Description description) {
        this.location = description.getTestClass().getSimpleName();
        return super.apply(base, description);
    }

    protected void before() throws Throwable {
        logger.info("Unpacking Mule Distribution: " + this.distribution);
        this.muleHome = new DistroUnzipper(this.distribution, WORKING_DIRECTORY.resolve(this.location).toFile()).unzip().muleHome();
    }

    protected void after() {
        File dest = new File(new File("logs"), this.location);
        FileUtils.deleteQuietly((File)dest);
        if (StringUtils.isEmpty((String)DELETE_ON_EXIT) || Boolean.parseBoolean(DELETE_ON_EXIT)) {
            try {
                logger.info("Deleting Mule Installation");
                File logs = new File(this.muleHome, "logs");
                FileUtils.moveDirectory((File)logs, (File)dest);
                FileUtils.deleteQuietly((File)this.muleHome);
            }
            catch (IOException e) {
                logger.warn("Couldn't delete directory [" + this.muleHome + "], delete it manually. Root exception: " + e.getMessage());
            }
        }
    }
}

