/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.runtime.core.util.FilenameUtils;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderManager;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.impl.internal.MuleArtifactResourcesRegistry;
import org.mule.runtime.module.deployment.impl.internal.application.DefaultApplicationFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.TemporaryArtifactBuilderFactory;
import org.mule.runtime.module.deployment.impl.internal.temporary.DefaultTemporaryArtifactBuilderFactory;
import org.mule.runtime.module.deployment.internal.MuleDeploymentService;
import org.mule.runtime.module.launcher.coreextension.DefaultMuleCoreExtensionManagerServer;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionDependencyResolver;
import org.mule.runtime.module.launcher.coreextension.ReflectionMuleCoreExtensionDependencyResolver;
import org.mule.runtime.module.repository.api.RepositoryService;
import org.mule.runtime.module.repository.internal.RepositoryServiceFactory;
import org.mule.runtime.module.service.ServiceManager;
import org.mule.runtime.module.tooling.api.ToolingService;
import org.mule.runtime.module.tooling.internal.DefaultToolingService;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

public class FakeMuleServer {
    protected static final int DEPLOYMENT_TIMEOUT = 20000;
    private final RepositoryService repositoryService;
    private File muleHome;
    private File appsDir;
    private File domainsDir;
    private File logsDir;
    private File serverPluginsDir;
    private File servicesDir;
    private final DeploymentService deploymentService;
    private final DeploymentListener domainDeploymentListener;
    private final DeploymentListener deploymentListener;
    private final ToolingService toolingService;
    private final List<MuleCoreExtension> coreExtensions;
    public static final String FAKE_SERVER_DISABLE_LOG_REPOSITORY_SELECTOR = "fake.server.disablelogrepositoryselector";
    private DefaultMuleCoreExtensionManagerServer coreExtensionManager;
    private final ArtifactClassLoader containerClassLoader;
    private ServiceManager serviceManager;

    public FakeMuleServer(String muleHomePath) {
        this(muleHomePath, new LinkedList<MuleCoreExtension>());
    }

    public FakeMuleServer(String muleHomePath, List<MuleCoreExtension> intialCoreExtensions) {
        MuleArtifactResourcesRegistry muleArtifactResourcesRegistry = new MuleArtifactResourcesRegistry();
        this.containerClassLoader = muleArtifactResourcesRegistry.getContainerClassLoader();
        this.serviceManager = muleArtifactResourcesRegistry.getServiceManager();
        this.coreExtensions = intialCoreExtensions;
        for (MuleCoreExtension extension : this.coreExtensions) {
            extension.setContainerClassLoader(this.containerClassLoader);
        }
        this.muleHome = new File(muleHomePath);
        this.muleHome.deleteOnExit();
        try {
            System.setProperty("mule.home", this.getMuleHome().getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.setMuleFolders();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.repositoryService = new RepositoryServiceFactory().createRepositoryService();
        this.toolingService = new DefaultToolingService((DefaultApplicationFactory)muleArtifactResourcesRegistry.getTemporaryApplicationFactory(), this.repositoryService, (TemporaryArtifactBuilderFactory)new DefaultTemporaryArtifactBuilderFactory(muleArtifactResourcesRegistry));
        this.deploymentService = new MuleDeploymentService(muleArtifactResourcesRegistry.getDomainFactory(), muleArtifactResourcesRegistry.getApplicationFactory());
        this.deploymentListener = (DeploymentListener)Mockito.mock(DeploymentListener.class);
        this.deploymentService.addDeploymentListener(this.deploymentListener);
        this.domainDeploymentListener = (DeploymentListener)Mockito.mock(DeploymentListener.class);
        this.deploymentService.addDomainDeploymentListener(this.domainDeploymentListener);
        this.coreExtensionManager = new DefaultMuleCoreExtensionManagerServer(() -> this.coreExtensions, (MuleCoreExtensionDependencyResolver)new ReflectionMuleCoreExtensionDependencyResolver());
        this.coreExtensionManager.setDeploymentService(this.deploymentService);
        this.coreExtensionManager.setToolingService(this.toolingService);
        this.coreExtensionManager.setArtifactClassLoaderManager((ArtifactClassLoaderManager)muleArtifactResourcesRegistry.getArtifactClassLoaderManager());
    }

    public void stop() throws MuleException {
        this.deploymentService.stop();
        this.serviceManager.stop();
        this.coreExtensionManager.stop();
        this.coreExtensionManager.dispose();
    }

    public void start() throws IOException, MuleException {
        this.coreExtensionManager.initialise();
        this.coreExtensionManager.start();
        this.serviceManager.start();
        this.deploymentService.start();
    }

    public void assertDeploymentSuccess(String appName) {
        this.assertDeploymentSuccess(this.deploymentListener, appName);
    }

    public void assertDeploymentFailure(String appName) {
        this.assertDeploymentFailure(this.deploymentListener, appName);
    }

    public void assertUndeploymentSuccess(String appName) {
        this.assertUndeploymentSuccess(this.deploymentListener, appName);
    }

    private void assertDeploymentFailure(final DeploymentListener listener, final String appName) {
        PollingProber prober = new PollingProber(20000L, 100L);
        prober.check(new Probe(){

            public boolean isSatisfied() {
                try {
                    ((DeploymentListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).onDeploymentFailure((String)Matchers.eq((Object)appName), (Throwable)Matchers.any(Throwable.class));
                    return true;
                }
                catch (AssertionError e) {
                    return false;
                }
            }

            public String describeFailure() {
                return "Failed to deploy application: " + appName;
            }
        });
    }

    private void assertDeploymentSuccess(final DeploymentListener listener, final String appName) {
        PollingProber prober = new PollingProber(20000L, 100L);
        prober.check(new Probe(){

            public boolean isSatisfied() {
                try {
                    ((DeploymentListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).onDeploymentSuccess(appName);
                    return true;
                }
                catch (AssertionError e) {
                    return false;
                }
            }

            public String describeFailure() {
                return "Failed to deploy application: " + appName;
            }
        });
    }

    public void assertUndeploymentSuccess(final DeploymentListener listener, final String appName) {
        PollingProber prober = new PollingProber(20000L, 100L);
        prober.check(new Probe(){

            public boolean isSatisfied() {
                try {
                    ((DeploymentListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).onUndeploymentSuccess(appName);
                    return true;
                }
                catch (AssertionError e) {
                    return false;
                }
            }

            public String describeFailure() {
                return "Failed to deploy application: " + appName;
            }
        });
    }

    private void setMuleFolders() throws IOException {
        this.appsDir = this.createFolder("apps");
        this.logsDir = this.createFolder("logs");
        this.serverPluginsDir = this.createFolder("server-plugins");
        this.servicesDir = this.createFolder("services");
        this.domainsDir = this.createFolder("domains");
        this.createFolder("domains/default");
        File confDir = this.createFolder("conf");
        URL log4jFile = this.getClass().getResource("/log4j2-test.xml");
        FileUtils.copyURLToFile((URL)log4jFile, (File)new File(confDir, "log4j2-test.xml"));
    }

    private File createFolder(String folderName) {
        File folder = new File(this.getMuleHome(), folderName);
        if (!folder.exists() && !folder.mkdirs()) {
            throw new IllegalStateException(String.format("Unable to create folder '%s'", folderName));
        }
        return folder;
    }

    public void addAppArchive(URL url) throws IOException {
        this.addAppArchive(url, null);
    }

    public void deploy(String resource) throws IOException {
        int lastSeparator = resource.lastIndexOf(File.separator);
        String appName = StringUtils.removeEndIgnoreCase((String)resource.substring(lastSeparator + 1), (String)".zip");
        this.deploy(resource, appName);
    }

    public void deploy(String resource, String targetAppName) throws IOException {
        URL url = this.getClass().getResource(resource);
        this.deploy(url, targetAppName);
    }

    public void deploy(URL resource, String targetAppName) throws IOException {
        this.addAppArchive(resource, targetAppName + ".zip");
        this.assertDeploymentSuccess(targetAppName);
    }

    private void addAppArchive(URL url, String targetFile) throws IOException {
        String tempFileName = new File((targetFile == null ? url.getFile() : targetFile) + ".part").getName();
        File tempFile = new File(this.appsDir, tempFileName);
        FileUtils.copyURLToFile((URL)url, (File)tempFile);
        boolean renamed = tempFile.renameTo(new File(StringUtils.removeEnd((String)tempFile.getAbsolutePath(), (String)".part")));
        if (!renamed) {
            throw new IllegalStateException("Unable to add application archive");
        }
    }

    public void addZippedServerPlugin(File plugin) throws IOException {
        this.addZippedServerPlugin(plugin.toURI().toURL());
    }

    public void addZippedServerPlugin(URL resource) throws IOException {
        String baseName = FilenameUtils.getName((String)resource.getPath());
        File tempFile = new File(this.getServerPluginsDir(), baseName);
        FileUtils.copyURLToFile((URL)resource, (File)tempFile);
    }

    public void addZippedService(File service) throws IOException {
        this.addZippedService(service.toURI().toURL());
    }

    public void addZippedService(URL resource) throws IOException {
        String baseName = FilenameUtils.getName((String)resource.getPath());
        File tempFile = new File(this.getServicesDir(), baseName);
        FileUtils.copyURLToFile((URL)resource, (File)tempFile);
    }

    public File getMuleHome() {
        return this.muleHome;
    }

    public File getLogsDir() {
        return this.logsDir;
    }

    public File getAppsDir() {
        return this.appsDir;
    }

    private File getDomainsDir() {
        return this.domainsDir;
    }

    public File getServerPluginsDir() {
        return this.serverPluginsDir;
    }

    public File getServicesDir() {
        return this.servicesDir;
    }

    public void resetDeploymentListener() {
        Mockito.reset((Object[])new DeploymentListener[]{this.deploymentListener});
    }

    public void addCoreExtension(MuleCoreExtension coreExtension) {
        coreExtension.setContainerClassLoader(this.containerClassLoader);
        this.coreExtensions.add(coreExtension);
    }

    public void addDeploymentListener(DeploymentListener listener) {
        this.deploymentService.addDeploymentListener(listener);
    }

    public void removeDeploymentListener(DeploymentListener listener) {
        this.deploymentService.removeDeploymentListener(listener);
    }

    public Application findApplication(String appName) {
        return this.deploymentService.findApplication(appName);
    }

    public void deployDomainFromClasspathFolder(String domainFolder, String domainName) {
        this.copyExplodedArtifactFromClasspathFolderToDeployFolder(domainFolder, this.getDomainsDir(), domainName);
    }

    public void deployDomainFromFolder(File domainFolder, String domainName) {
        this.copyExplodedArtifactFromFolderToDeployFolder(domainFolder, this.getDomainsDir(), domainName);
    }

    public void deployAppFromClasspathFolder(String appFolder, String appName) {
        this.copyExplodedArtifactFromClasspathFolderToDeployFolder(appFolder, this.getAppsDir(), appName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyExplodedArtifactFromClasspathFolderToDeployFolder(String artifactFolderPath, File artifactDirectory, String artifactName) {
        ReentrantLock lock = this.deploymentService.getLock();
        lock.lock();
        try {
            URL resource = this.getClass().getClassLoader().getResource(artifactFolderPath);
            File artifactFolder = new File(resource.getFile());
            this.copyExplodedArtifactFromFolderToDeployFolder(artifactFolder, artifactDirectory, artifactName);
        }
        finally {
            lock.unlock();
        }
    }

    private void copyExplodedArtifactFromFolderToDeployFolder(File artifactFolder, File artifactDirectory, String artifactName) {
        ReentrantLock lock = this.deploymentService.getLock();
        lock.lock();
        try {
            org.mule.runtime.core.util.FileUtils.copyDirectory((File)artifactFolder, (File)new File(artifactDirectory, artifactName));
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    static {
        if (!Boolean.getBoolean(FAKE_SERVER_DISABLE_LOG_REPOSITORY_SELECTOR)) {
            System.setProperty("mule.simpleLog", "true");
        }
    }
}

