/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.core.util.FileUtils;
import org.mule.test.infrastructure.deployment.FakeMuleServer;
import org.mule.test.infrastructure.process.ApplicationStartedDeploymentListener;

public class MuleContextProcessApplication {
    public static final String TEST_APPLICATION_NAME = "test-app";
    private static Socket logSocket;
    private static Socket commandSocket;

    public static void main(String[] args) throws IOException {
        try {
            try {
                long initialTime = System.currentTimeMillis();
                MuleContextProcessApplication.replaceSystemOutputWithSocketOutput();
                System.out.println("MuleContextProcessApplication attached to log port");
                System.out.println("Creating fake mule server");
                String muleHomeSystemProperty = System.getProperty("mule.home");
                System.out.println("Using mule home: " + muleHomeSystemProperty);
                FakeMuleServer fakeMuleServer = new FakeMuleServer(muleHomeSystemProperty, MuleContextProcessApplication.retrieveConfiguredCoreExtensions());
                File appsDirectory = fakeMuleServer.getAppsDir();
                System.out.println("Creating test app directory");
                File applicationDirectory = new File(appsDirectory, TEST_APPLICATION_NAME);
                if (!applicationDirectory.exists() && !applicationDirectory.mkdir()) {
                    throw new RuntimeException("Could not create test-app directory to create test application within fake mule serevr");
                }
                System.out.println("Test app directory created");
                System.out.println("Creating app config file");
                String applicationConfiguration = System.getProperty("configFile");
                File applicationConfigurationFile = new File(MuleContextProcessApplication.class.getClassLoader().getResource(applicationConfiguration).getFile());
                if (!applicationConfigurationFile.exists()) {
                    throw new RuntimeException("Could not find file for application configuration " + applicationConfiguration);
                }
                FileUtils.copyFile((File)applicationConfigurationFile, (File)new File(applicationDirectory, "mule-config.xml"));
                System.out.println("Test app config file created");
                ApplicationStartedDeploymentListener applicationStartedDeploymentListener = new ApplicationStartedDeploymentListener();
                fakeMuleServer.addDeploymentListener(applicationStartedDeploymentListener);
                System.out.println("Starting fake mule server");
                fakeMuleServer.start();
                System.out.println("Fake mule server started");
                applicationStartedDeploymentListener.waitUntilApplicationDeployed();
                MuleContextProcessApplication.notifyMuleContextStarted();
                while (true) {
                    if (System.currentTimeMillis() - initialTime > (long)(Integer.valueOf(System.getProperty("processTimeout")) * 1000)) {
                        System.exit(-1);
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (Throwable e) {
                System.out.println("Failure starting process: " + e.getMessage());
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            MuleContextProcessApplication.closeQuietly(logSocket);
            throw throwable;
        }
    }

    private static List<MuleCoreExtension> retrieveConfiguredCoreExtensions() {
        ArrayList<MuleCoreExtension> muleCoreExtensions = new ArrayList<MuleCoreExtension>();
        String coreExtensionsProperty = System.getProperty("test.mule.coreextension");
        if (coreExtensionsProperty != null) {
            String[] coreExtensionsAsString;
            for (String coreExtensionClassName : coreExtensionsAsString = coreExtensionsProperty.split(",")) {
                try {
                    muleCoreExtensions.add((MuleCoreExtension)ClassUtils.getClass((String)coreExtensionClassName).newInstance());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return muleCoreExtensions;
    }

    private static void notifyMuleContextStarted() throws IOException {
        System.out.println("About to send mule context started notification");
        String commandServerPort = System.getProperty("test.command.port");
        commandSocket = new Socket("localhost", (int)Integer.valueOf(commandServerPort));
        System.out.println("Connecting command client to " + commandServerPort);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(commandSocket.getOutputStream());
        outputStreamWriter.write("MuleContext:started\n");
        outputStreamWriter.flush();
        System.out.println("Mule context started notification sent");
    }

    private static void replaceSystemOutputWithSocketOutput() throws IOException {
        String tcpPortForLoggingPropertyValue = System.getProperty("test.log.port");
        logSocket = new Socket("localhost", (int)Integer.valueOf(tcpPortForLoggingPropertyValue));
        System.setOut(new PrintStream(logSocket.getOutputStream(), true));
        System.setErr(new PrintStream(logSocket.getOutputStream(), true));
    }

    private static void closeQuietly(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

