/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process;

import java.io.File;
import org.apache.commons.lang.SystemUtils;
import org.mule.test.infrastructure.process.Controller;
import org.mule.test.infrastructure.process.UnixController;
import org.mule.test.infrastructure.process.WindowsController;

public class MuleProcessController {
    private static final int DEFAULT_TIMEOUT = 60000;
    private Controller controller;

    public MuleProcessController(String muleHome) {
        this(muleHome, 60000);
    }

    public MuleProcessController(String muleHome, int timeout) {
        this.controller = SystemUtils.IS_OS_WINDOWS ? new WindowsController(muleHome, timeout) : new UnixController(muleHome, timeout);
    }

    public boolean isRunning() {
        return this.controller.isRunning();
    }

    public void start(String ... args) {
        this.controller.start(args);
    }

    public void stop(String ... args) {
        this.controller.stop(args);
    }

    public int status(String ... args) {
        return this.controller.status(args);
    }

    public int getProcessId() {
        return this.controller.getProcessId();
    }

    public void restart(String ... args) {
        this.controller.restart(args);
    }

    public void deploy(String path) {
        this.controller.deploy(path);
    }

    public boolean isDeployed(String appName) {
        return this.controller.isDeployed(appName);
    }

    public boolean isDomainDeployed(String domainName) {
        return this.controller.isDomainDeployed(domainName);
    }

    public void undeploy(String application) {
        this.controller.undeploy(application);
    }

    public void undeployDomain(String domain) {
        this.controller.undeployDomain(domain);
    }

    public void undeployAll() {
        this.controller.undeployAll();
    }

    public void installLicense(String path) {
        this.controller.installLicense(path);
    }

    public void uninstallLicense() {
        this.controller.uninstallLicense();
    }

    public void addLibrary(File jar) {
        this.controller.addLibrary(jar);
    }

    public void deployDomain(String domain) {
        this.controller.deployDomain(domain);
    }

    public File getLog() {
        return this.controller.getLog();
    }

    public File getLog(String appName) {
        return this.controller.getLog(appName);
    }

    public void addConfProperty(String value) {
        this.controller.addConfProperty(value);
    }
}

