/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.apache.commons.io.FileUtils;

public class MuleUtils {
    private static final long TIMEOUT = 1800000L;
    private String muleHome;
    private String populateM2repoCommand;

    public MuleUtils(String muleHome) {
        this.muleHome = muleHome;
        this.populateM2repoCommand = muleHome + "/bin/populate_m2_repo";
    }

    public void populateM2Repo(String repo) throws IOException {
        File repository = new File(repo);
        if (!repository.exists()) {
            FileUtils.forceMkdir((File)repository);
        }
        if (!repository.isDirectory()) {
            throw new IllegalArgumentException("Repository should be a directory.");
        }
        MuleUtils.executeCommand(this.populateM2repoCommand + " " + repo, "MULE_HOME=" + this.muleHome);
    }

    public static int executeCommand(String command, String ... envVars) throws IOException {
        CommandLine cmdLine = CommandLine.parse((String)command);
        DefaultExecutor executor = new DefaultExecutor();
        Map<String, String> env = MuleUtils.addEnvProperties(envVars);
        ExecuteWatchdog watchDog = new ExecuteWatchdog(1800000L);
        executor.setWatchdog(watchDog);
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        int result = executor.execute(cmdLine, env);
        if (executor.isFailure(result)) {
            if (watchDog.killedProcess()) {
                throw new RuntimeException("Reached timeout while running: " + String.valueOf(cmdLine));
            }
            throw new RuntimeException("Process failed with return code [" + result + "]: " + String.valueOf(cmdLine));
        }
        return result;
    }

    private static Map<String, String> addEnvProperties(String[] envVars) throws IOException {
        Map env = EnvironmentUtils.getProcEnvironment();
        for (String envVar : envVars) {
            EnvironmentUtils.addVariableToEnvironment((Map)env, (String)envVar);
        }
        return env;
    }
}

