/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process.rules;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.derby.drda.NetworkServerControl;
import org.awaitility.Awaitility;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyServer
extends ExternalResource
implements Closeable {
    private static final String URI_TEMPLATE = "jdbc:derby://%s:%d/%s;create=true";
    private static final String DRIVER_CLASS = "org.apache.derby.jdbc.ClientDriver";
    private static final String DERBY_SYSTEM_HOME = "derby.system.home";
    private static final String DERBY_HOME = Paths.get(System.getProperty("user.dir"), new String[0]).resolve("derby.home").toString();
    private static final String HOST = "127.0.0.1";
    private static Logger logger = LoggerFactory.getLogger(DerbyServer.class);
    private NetworkServerControl server;
    private final int port;

    public DerbyServer(int port) {
        System.setProperty(DERBY_SYSTEM_HOME, DERBY_HOME);
        this.port = port;
    }

    public String getUri(String name) {
        return String.format(URI_TEMPLATE, HOST, this.port, name);
    }

    public String getDriverClass() {
        return DRIVER_CLASS;
    }

    public void before() {
        this.start();
    }

    public void after() {
        this.stop();
    }

    public DerbyServer start() {
        try {
            this.server = new NetworkServerControl(InetAddress.getByName(HOST), this.port);
            this.server.start(new PrintWriter(new LogWriter()));
            Awaitility.await().until(() -> this.isRunning());
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't start Derby server", e);
        }
        logger.info("Started Derby Database server.");
        return this;
    }

    public boolean isRunning() {
        try {
            this.server.ping();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void stop() {
        try {
            this.server.shutdown();
            FileUtils.deleteQuietly((File)new File(DERBY_HOME));
            logger.info("Stopped Derby Database server.");
        }
        catch (Exception e) {
            logger.error("Failed to stop Database server: " + e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    private static class LogWriter
    extends Writer {
        private LogWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            logger.debug(new String(cbuf, off, len));
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

