/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.profiling.tracing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyIterable;
import org.hamcrest.collection.IsMapContaining;
import org.junit.Assert;
import org.mule.runtime.tracer.api.sniffer.CapturedEventData;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.test.infrastructure.profiling.tracing.ExceptionEventMatcher;

public class SpanTestHierarchy {
    public static final String LOCATION_KEY = "location";
    public static final String UNSET_STATUS = "UNSET";
    public static final String ERROR_STATUS = "ERROR";
    public static final String OK_STATUS = "OK";
    private SpanNode root;
    private SpanNode currentNode;
    private SpanNode lastChild;
    private static final String NO_PARENT_SPAN = "0000000000000000";
    private final HashSet<String> visitedSpans = new HashSet();
    private final HashMap<String, CapturedExportedSpan> spanHashMap = new HashMap();
    private Collection<CapturedExportedSpan> actualExportedSpans;

    public SpanTestHierarchy(Collection<CapturedExportedSpan> actualExportedSpans) {
        this.actualExportedSpans = actualExportedSpans;
        actualExportedSpans.forEach(span -> this.spanHashMap.put(span.getSpanId(), (CapturedExportedSpan)span));
    }

    public SpanTestHierarchy() {
        new SpanTestHierarchy(Collections.emptyList());
    }

    public int size() {
        return 1 + this.size(this.root);
    }

    private int size(SpanNode current) {
        return current.children.size() + current.children.stream().map(this::size).reduce(0, Integer::sum);
    }

    public SpanTestHierarchy withCapturedSpans(Collection<CapturedExportedSpan> actualExportedSpans) {
        this.actualExportedSpans = actualExportedSpans;
        actualExportedSpans.forEach(span -> this.spanHashMap.put(span.getSpanId(), (CapturedExportedSpan)span));
        return this;
    }

    public SpanTestHierarchy withRoot(String rootName) {
        this.root = new SpanNode(rootName);
        this.root.parent = new SpanNode(NO_PARENT_SPAN);
        this.currentNode = this.root;
        return this;
    }

    public SpanTestHierarchy beginChildren() {
        this.lastChild = this.currentNode;
        return this;
    }

    public SpanTestHierarchy child(String childName) {
        SpanNode child = new SpanNode(childName);
        child.parent = this.lastChild;
        this.lastChild.addChild(child);
        this.currentNode = child;
        return this;
    }

    public SpanTestHierarchy endChildren() {
        if (this.currentNode != null && this.currentNode.parent != null) {
            this.lastChild = this.lastChild.parent;
            this.currentNode = this.currentNode.parent.parent;
        }
        return this;
    }

    public SpanTestHierarchy addKindToAssert(String kind) {
        this.currentNode.addKindToAssert(kind);
        return this;
    }

    public SpanTestHierarchy addAttributeToAssertValue(String key, String value) {
        this.currentNode.addAttributeThatShouldMatch(key, value);
        return this;
    }

    public SpanTestHierarchy addAttributesToAssertValue(Map<String, String> attributes) {
        this.currentNode.addAttributesThatShouldMatch(attributes);
        return this;
    }

    public SpanTestHierarchy addAttributesToAssertExistence(List<String> attributeNames) {
        this.currentNode.addAttributeThatShouldExist(attributeNames);
        return this;
    }

    public SpanTestHierarchy addAttributesToAssertExistence(String ... attributeNames) {
        this.currentNode.addAttributeThatShouldExist(Arrays.asList(attributeNames));
        return this;
    }

    public SpanTestHierarchy addExceptionData(String errorType, String errorDescription) {
        this.currentNode.expectException(errorType, errorDescription);
        return this;
    }

    public SpanTestHierarchy addExceptionData(String errorType, String errorDescription, String errorStacktrace) {
        this.currentNode.expectException(errorType, errorDescription, errorStacktrace);
        return this;
    }

    public SpanTestHierarchy addExceptionData(String errorType) {
        this.currentNode.expectException(errorType);
        return this;
    }

    public SpanTestHierarchy addStatusData(String status) {
        this.currentNode.expectStatus(status);
        return this;
    }

    public SpanNode getRoot() {
        return this.root;
    }

    public void assertSpanTree() {
        this.visitedSpans.clear();
        this.assertSpanTree(this.root, null);
    }

    private void assertSpanTree(SpanNode expectedNode, CapturedExportedSpan actualParent) {
        CapturedExportedSpan actualSpan = this.assertActualSpan(expectedNode, actualParent);
        for (SpanNode expectedChild : expectedNode.children) {
            this.assertSpanTree(expectedChild, actualSpan);
        }
    }

    private CapturedExportedSpan assertActualSpan(SpanNode expectedNode, CapturedExportedSpan actualParent) {
        CapturedExportedSpan actualSpan = this.actualExportedSpans.stream().filter(exportedSpan -> !this.visitedSpans.contains(exportedSpan.getSpanId()) && exportedSpan.getName().equals(expectedNode.spanName) && this.hasCorrectLocation((CapturedExportedSpan)exportedSpan, expectedNode.getAttribute(LOCATION_KEY)) && this.hasCorrectParent((CapturedExportedSpan)exportedSpan, actualParent != null ? actualParent.getName() : null) && this.hasCorrectStatus((CapturedExportedSpan)exportedSpan, expectedNode)).findFirst().orElse(null);
        MatcherAssert.assertThat((String)("Expected span: " + expectedNode.spanName + " was not found"), (Object)actualSpan, (Matcher)Matchers.notNullValue());
        Assert.assertTrue((String)("Expected span: " + expectedNode.spanName + " has a different trace ID than parent"), (boolean)this.hasCorrectTraceId(actualSpan, actualParent != null ? actualParent.getName() : null));
        this.assertAttributes(actualSpan, expectedNode);
        this.assertTraceState(actualSpan, expectedNode);
        this.assertKind(actualSpan, expectedNode);
        this.assertException(actualSpan, expectedNode);
        MatcherAssert.assertThat((String)("Expected span: " + expectedNode.spanName + " has incorrect start or end time"), (Object)actualSpan.getStartEpochSpanNanos(), (Matcher)CoreMatchers.is((Matcher)Matchers.lessThan((Comparable)Long.valueOf(actualSpan.getEndSpanEpochNanos()))));
        this.visitedSpans.add(actualSpan.getSpanId());
        return actualSpan;
    }

    private void assertKind(CapturedExportedSpan actualSpan, SpanNode expectedNode) {
        if (expectedNode.getKind() != null && !expectedNode.getKind().equals(actualSpan.getSpanKindName())) {
            Assert.fail((String)("The span " + expectedNode.spanName + " was expected to have the kind " + expectedNode.getKind() + " but had " + actualSpan.getSpanKindName()));
        }
    }

    private void assertTraceState(CapturedExportedSpan actualSpan, SpanNode expectedNode) {
        expectedNode.getTraceStateEntriesToAssert().forEach((key, value) -> {
            String capturedTraceValue = (String)actualSpan.getTraceState().get(key);
            if (capturedTraceValue == null) {
                Assert.fail((String)("The span " + expectedNode.spanName + " has no trace state key " + key));
            }
            MatcherAssert.assertThat((String)("The span " + expectedNode.spanName + " has expected value " + value + " for key " + key + ". The value was " + capturedTraceValue), (Object)capturedTraceValue, (Matcher)Matchers.equalTo((Object)value));
        });
        expectedNode.getTraceStateKeyExistence().forEach(key -> {
            String capturedTraceValue = (String)actualSpan.getTraceState().get(key);
            if (capturedTraceValue == null) {
                Assert.fail((String)("The span " + expectedNode.spanName + " has no trace state key " + key));
            }
        });
        expectedNode.getTraceStateKeyNotExistence().forEach(key -> {
            String capturedTraceValue = (String)actualSpan.getTraceState().get(key);
            if (capturedTraceValue != null) {
                Assert.fail((String)("The span " + expectedNode.spanName + " has trace state key " + key + " and it must not be present"));
            }
        });
    }

    private boolean hasCorrectStatus(CapturedExportedSpan exportedSpan, SpanNode expectedNode) {
        if (expectedNode.status != null) {
            return expectedNode.status.equals(exportedSpan.getStatusAsString());
        }
        return true;
    }

    private boolean hasCorrectParent(CapturedExportedSpan span, String expectedParentName) {
        CapturedExportedSpan parentSpan = this.spanHashMap.get(span.getParentSpanId());
        if (expectedParentName != null && parentSpan == null) {
            return false;
        }
        if (expectedParentName == null && parentSpan == null) {
            return span.getParentSpanId().equals(NO_PARENT_SPAN);
        }
        return parentSpan.getName().equals(expectedParentName);
    }

    private boolean hasCorrectTraceId(CapturedExportedSpan span, String expectedParentName) {
        CapturedExportedSpan parentSpan = this.spanHashMap.get(span.getParentSpanId());
        if (expectedParentName != null && parentSpan == null) {
            return false;
        }
        if (expectedParentName == null && parentSpan == null) {
            return true;
        }
        return parentSpan.getTraceId().equals(span.getTraceId());
    }

    private boolean hasCorrectLocation(CapturedExportedSpan span, String expectedLocation) {
        return expectedLocation == null || ((String)span.getAttributes().get(LOCATION_KEY)).equals(expectedLocation);
    }

    private void assertAttributes(CapturedExportedSpan actualSpan, SpanNode expectedNode) {
        expectedNode.getAttributesThatShouldMatch().forEach((key, value) -> MatcherAssert.assertThat((String)("Actual attribute \"" + key + "\" for: " + expectedNode.spanName + " is not the expected one"), (Object)actualSpan.getAttributes(), (Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)key), (Matcher)Matchers.equalTo((Object)value))));
        expectedNode.getAttributesThatShouldExist().forEach(attribute -> MatcherAssert.assertThat((String)("Actual attribute \"" + attribute + "\" for: " + expectedNode.spanName + " does not exist"), (Object)actualSpan.getAttributes(), (Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)attribute), (Matcher)Matchers.notNullValue())));
    }

    private void assertException(CapturedExportedSpan actualSpan, SpanNode expectedNode) {
        expectedNode.assertExceptions(actualSpan);
    }

    public SpanTestHierarchy addTraceStateKeyValueAssertion(String key, String value) {
        this.currentNode.addTraceStateKeyValueToAssert(key, value);
        return this;
    }

    public SpanTestHierarchy addTraceStateKeyNotPresentAssertion(String key) {
        this.currentNode.addTraceStateKeyAssertNotExistence(key);
        return this;
    }

    public SpanTestHierarchy addTraceStateKeyPresentAssertion(String key) {
        this.currentNode.addTraceStateKeyAssertExistence(key);
        return this;
    }

    private static class SpanNode {
        private final String spanName;
        private SpanNode parent;
        private final List<SpanNode> children = new ArrayList<SpanNode>();
        private final Map<String, String> attributesThatShouldMatch = new HashMap<String, String>();
        private final List<String> attributesThatShouldExist = new ArrayList<String>();
        private Matcher<CapturedEventData> exceptionEventMatcher;
        private String status = null;
        private final Map<String, String> traceStateEntriesToAssert = new HashMap<String, String>();
        private List<String> traceStateKeyExistence = new ArrayList<String>();
        private List<String> traceStateKeyNotExistence = new ArrayList<String>();
        private String kindToAssert;

        public SpanNode(String spanName) {
            this.spanName = spanName;
        }

        public void addChild(SpanNode child) {
            this.children.add(child);
        }

        public void addAttributeThatShouldMatch(String key, String value) {
            this.attributesThatShouldMatch.put(key, value);
        }

        public void addAttributesThatShouldMatch(Map<String, String> attributesThatShouldMatch) {
            this.attributesThatShouldMatch.putAll(attributesThatShouldMatch);
        }

        public void addAttributeThatShouldExist(List<String> attributes) {
            this.attributesThatShouldExist.addAll(attributes);
        }

        public void expectException(String errorType, String errorDescription) {
            this.exceptionEventMatcher = ExceptionEventMatcher.withType(errorType).withDescription(errorDescription);
        }

        public void expectException(String errorType, String errorDescription, String errorStacktrace) {
            this.exceptionEventMatcher = ExceptionEventMatcher.withType(errorType).withDescription(errorDescription).withStackTrace(errorStacktrace);
        }

        public void expectStatus(String status) {
            this.status = status;
        }

        public void expectException(String errorType) {
            this.exceptionEventMatcher = ExceptionEventMatcher.withType(errorType);
        }

        public String getAttribute(String key) {
            return this.attributesThatShouldMatch.get(key);
        }

        public Map<String, String> getAttributesThatShouldMatch() {
            return this.attributesThatShouldMatch;
        }

        public List<String> getAttributesThatShouldExist() {
            return this.attributesThatShouldExist;
        }

        public void assertExceptions(CapturedExportedSpan actualSpan) {
            List exceptionEvents = actualSpan.getEvents().stream().filter(capturedEventData -> capturedEventData.getName().equals("exception")).collect(Collectors.toList());
            if (this.exceptionEventMatcher == null) {
                MatcherAssert.assertThat((String)String.format("Unexpected exception events found for Span: [%s]", actualSpan), exceptionEvents, (Matcher)IsEmptyIterable.emptyIterable());
                MatcherAssert.assertThat((Object)actualSpan.getStatusAsString(), (Matcher)Matchers.in(this.status != null ? Collections.singleton(this.status) : Arrays.asList(SpanTestHierarchy.UNSET_STATUS, SpanTestHierarchy.OK_STATUS)));
            } else {
                MatcherAssert.assertThat((String)String.format("Expected exception events for Span: [%s] where not match", actualSpan), exceptionEvents, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.exceptionEventMatcher}));
                MatcherAssert.assertThat((Object)actualSpan.getStatusAsString(), (Matcher)CoreMatchers.is((Object)(this.status != null ? this.status : SpanTestHierarchy.ERROR_STATUS)));
            }
        }

        public void addTraceStateKeyValueToAssert(String key, String value) {
            this.traceStateEntriesToAssert.put(key, value);
        }

        public Map<String, String> getTraceStateEntriesToAssert() {
            return this.traceStateEntriesToAssert;
        }

        public List<String> getTraceStateKeyExistence() {
            return this.traceStateKeyExistence;
        }

        public List<String> getTraceStateKeyNotExistence() {
            return this.traceStateKeyNotExistence;
        }

        public void addTraceStateKeyAssertNotExistence(String key) {
            this.traceStateKeyNotExistence.add(key);
        }

        public void addTraceStateKeyAssertExistence(String key) {
            this.traceStateKeyExistence.add(key);
        }

        public void addKindToAssert(String kindToAssert) {
            this.kindToAssert = kindToAssert;
        }

        public String getKind() {
            return this.kindToAssert;
        }
    }
}

