/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Strings;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.artifact.ArtifactConfigurationProcessor;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.internal.memory.management.DefaultMemoryManagementService;
import org.mule.runtime.internal.memory.management.ProfiledMemoryManagementService;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderManager;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.impl.internal.MuleArtifactResourcesRegistry;
import org.mule.runtime.module.deployment.internal.DeploymentServiceBuilder;
import org.mule.runtime.module.deployment.internal.MuleDeploymentService;
import org.mule.runtime.module.deployment.internal.processor.SerializedAstArtifactConfigurationProcessor;
import org.mule.runtime.module.launcher.coreextension.DefaultMuleCoreExtensionManagerServer;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionDependencyResolver;
import org.mule.runtime.module.launcher.coreextension.ReflectionMuleCoreExtensionDependencyResolver;
import org.mule.runtime.module.log4j.internal.MuleLog4jConfiguratorUtils;
import org.mule.runtime.module.repository.api.RepositoryService;
import org.mule.runtime.module.repository.internal.RepositoryServiceFactory;
import org.mule.runtime.module.service.api.manager.ServiceManager;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

public class FakeMuleServer {
    protected static final int DEPLOYMENT_TIMEOUT = 20000;
    private final RepositoryService repositoryService;
    private final File muleHome;
    private File appsDir;
    private File domainsDir;
    private File logsDir;
    private File serverPluginsDir;
    private File servicesDir;
    private final DeploymentService deploymentService;
    private final DeploymentListener domainDeploymentListener;
    private final DeploymentListener deploymentListener;
    private final List<MuleCoreExtension> coreExtensions;
    public static final String FAKE_SERVER_DISABLE_LOG_REPOSITORY_SELECTOR = "fake.server.disablelogrepositoryselector";
    private final MuleArtifactResourcesRegistry muleArtifactResourcesRegistry = new MuleArtifactResourcesRegistry.Builder().artifactConfigurationProcessor(Objects.requireNonNullElseGet(ArtifactConfigurationProcessor.discover(), () -> SerializedAstArtifactConfigurationProcessor.serializedAstWithFallbackArtifactConfigurationProcessor())).withMemoryManagementService((ProfiledMemoryManagementService)DefaultMemoryManagementService.newDefaultMemoryManagementService()).withActionOnMuleArtifactDeployment(MuleLog4jConfiguratorUtils.getDefaultReconfigurationAction()).build();
    private final DefaultMuleCoreExtensionManagerServer coreExtensionManager;
    private final ArtifactClassLoader containerClassLoader;
    private final ServiceManager serviceManager;
    private final ExtensionModelLoaderRepository extensionModelLoaderRepository;

    public FakeMuleServer(String muleHomePath) {
        this(muleHomePath, new LinkedList<MuleCoreExtension>());
    }

    public FakeMuleServer(String muleHomePath, List<MuleCoreExtension> intialCoreExtensions) {
        this.muleArtifactResourcesRegistry.inject((Object)this.muleArtifactResourcesRegistry.getContainerProfilingService());
        this.containerClassLoader = this.muleArtifactResourcesRegistry.getContainerClassLoader();
        this.serviceManager = this.muleArtifactResourcesRegistry.getServiceManager();
        this.extensionModelLoaderRepository = this.muleArtifactResourcesRegistry.getExtensionModelLoaderRepository();
        this.coreExtensions = intialCoreExtensions;
        for (MuleCoreExtension extension : this.coreExtensions) {
            extension.setContainerClassLoader(this.containerClassLoader);
        }
        this.muleHome = new File(muleHomePath);
        this.muleHome.deleteOnExit();
        try {
            System.setProperty("mule.home", this.getMuleHome().getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.setMuleFolders();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.repositoryService = new RepositoryServiceFactory().createRepositoryService();
        this.deploymentService = DeploymentServiceBuilder.deploymentServiceBuilder().withArtifactStartExecutorSupplier(() -> MuleDeploymentService.findSchedulerService((ServiceRepository)this.serviceManager)).withDomainFactory(this.muleArtifactResourcesRegistry.getDomainFactory()).withApplicationFactory(this.muleArtifactResourcesRegistry.getApplicationFactory()).build();
        this.deploymentListener = (DeploymentListener)Mockito.mock(DeploymentListener.class);
        ((DeploymentListener)Mockito.doAnswer(inv -> {
            String artifactName = (String)inv.getArgument(0);
            Throwable cause = (Throwable)inv.getArgument(1);
            System.err.println("Deployment failure for " + artifactName + ":");
            cause.printStackTrace();
            return null;
        }).when((Object)this.deploymentListener)).onDeploymentFailure(ArgumentMatchers.anyString(), (Throwable)ArgumentMatchers.any());
        this.deploymentService.addDeploymentListener(this.deploymentListener);
        this.domainDeploymentListener = (DeploymentListener)Mockito.mock(DeploymentListener.class);
        ((DeploymentListener)Mockito.doAnswer(inv -> {
            String artifactName = (String)inv.getArgument(0);
            Throwable cause = (Throwable)inv.getArgument(1);
            System.err.println("Domain Deployment failure for " + artifactName + ":");
            cause.printStackTrace();
            return null;
        }).when((Object)this.domainDeploymentListener)).onDeploymentFailure(ArgumentMatchers.anyString(), (Throwable)ArgumentMatchers.any());
        this.deploymentService.addDomainDeploymentListener(this.domainDeploymentListener);
        this.coreExtensionManager = new DefaultMuleCoreExtensionManagerServer(() -> this.coreExtensions, (MuleCoreExtensionDependencyResolver)new ReflectionMuleCoreExtensionDependencyResolver());
        this.coreExtensionManager.setDeploymentService(this.deploymentService);
        this.coreExtensionManager.setArtifactClassLoaderManager((ArtifactClassLoaderManager)this.muleArtifactResourcesRegistry.getArtifactClassLoaderManager());
        this.coreExtensionManager.setRepositoryService(this.repositoryService);
        this.coreExtensionManager.setServiceRepository((ServiceRepository)this.serviceManager);
    }

    public void stop() throws MuleException {
        this.deploymentService.stop();
        this.serviceManager.stop();
        LifecycleUtils.stopIfNeeded((Object)this.extensionModelLoaderRepository);
        this.coreExtensionManager.stop();
        this.coreExtensionManager.dispose();
    }

    public void start() throws IOException, MuleException {
        this.serviceManager.start();
        this.coreExtensionManager.initialise();
        this.coreExtensionManager.start();
        LifecycleUtils.startIfNeeded((Object)this.extensionModelLoaderRepository);
        this.deploymentService.start();
    }

    public MuleArtifactResourcesRegistry getMuleArtifactResourcesRegistry() {
        return this.muleArtifactResourcesRegistry;
    }

    public void assertDeploymentSuccess(String appName) {
        this.assertDeploymentSuccess(this.deploymentListener, appName);
    }

    public void assertDeploymentFailure(String appName) {
        this.assertDeploymentFailure(this.deploymentListener, appName);
    }

    public void assertUndeploymentSuccess(String appName) {
        this.assertUndeploymentSuccess(this.deploymentListener, appName);
    }

    private void assertDeploymentFailure(final DeploymentListener listener, final String appName) {
        PollingProber prober = new PollingProber(20000L, 100L);
        prober.check(new Probe(){

            public boolean isSatisfied() {
                try {
                    ((DeploymentListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).onDeploymentFailure((String)ArgumentMatchers.eq((Object)appName), (Throwable)ArgumentMatchers.any(Throwable.class));
                    return true;
                }
                catch (AssertionError e) {
                    return false;
                }
            }

            public String describeFailure() {
                return "Failed to deploy application: " + appName;
            }
        });
    }

    private void assertDeploymentSuccess(DeploymentListener listener, String aartifactName) {
        PollingProber.check((long)20000L, (long)100L, () -> {
            ((DeploymentListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onDeploymentFailure((String)ArgumentMatchers.eq((Object)aartifactName), (Throwable)ArgumentMatchers.any());
            ((DeploymentListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).onDeploymentSuccess(aartifactName);
            return true;
        });
    }

    public void assertUndeploymentSuccess(DeploymentListener listener, String artifactName) {
        PollingProber.check((long)20000L, (long)100L, () -> {
            ((DeploymentListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onUndeploymentFailure((String)ArgumentMatchers.eq((Object)artifactName), (Throwable)ArgumentMatchers.any());
            ((DeploymentListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).onUndeploymentSuccess(artifactName);
            return true;
        });
    }

    private void setMuleFolders() throws IOException {
        this.appsDir = this.createFolder("apps");
        this.logsDir = this.createFolder("logs");
        this.serverPluginsDir = this.createFolder("server-plugins");
        this.servicesDir = this.createFolder("services");
        this.domainsDir = this.createFolder("domains");
        File confDir = this.createFolder("conf");
        URL log4jFile = Thread.currentThread().getContextClassLoader().getResource("log4j2-test.xml");
        FileUtils.copyURLToFile((URL)log4jFile, (File)new File(confDir, "log4j2-test.xml"));
    }

    private File createFolder(String folderName) {
        File folder = new File(this.getMuleHome(), folderName);
        if (!folder.exists() && !folder.mkdirs()) {
            throw new IllegalStateException("Unable to create folder '%s'".formatted(folderName));
        }
        return folder;
    }

    public void addAppArchive(URL url) throws IOException, URISyntaxException {
        this.addAppArchive(url, null);
    }

    public void deploy(String resource) throws IOException, URISyntaxException {
        int lastSeparator = resource.lastIndexOf(File.separator);
        String appName = Strings.CI.removeEnd(resource.substring(lastSeparator + 1), (CharSequence)".jar");
        this.deploy(resource, appName);
    }

    public void deploy(String resource, String targetAppName) throws IOException, URISyntaxException {
        URL url = this.getClass().getResource(resource);
        this.deploy(url, targetAppName);
    }

    public void deploy(URL resource, String targetAppName) throws IOException, URISyntaxException {
        this.addAppArchive(resource, targetAppName + ".jar");
        this.assertDeploymentSuccess(targetAppName);
    }

    private void addAppArchive(URL url, String targetFile) throws IOException, URISyntaxException {
        String tempFileName = (targetFile == null ? new File(url.toURI()) : new File(targetFile)).getName() + ".part";
        File tempFile = new File(this.appsDir, tempFileName);
        FileUtils.copyURLToFile((URL)url, (File)tempFile);
        boolean renamed = tempFile.renameTo(new File(Strings.CS.removeEnd(tempFile.getAbsolutePath(), (CharSequence)".part")));
        if (!renamed) {
            throw new IllegalStateException("Unable to add application archive");
        }
    }

    public void addZippedServerPlugin(File plugin) throws IOException {
        this.addZippedServerPlugin(plugin.toURI().toURL());
    }

    public void addZippedServerPlugin(URL resource) throws IOException {
        String baseName = FilenameUtils.getName((String)resource.getPath());
        File tempFile = new File(this.getServerPluginsDir(), baseName);
        FileUtils.copyURLToFile((URL)resource, (File)tempFile);
    }

    public void addZippedService(File service) throws IOException {
        String baseName = FilenameUtils.getName((String)service.getPath());
        File tempFile = new File(this.getServicesDir(), baseName);
        FileUtils.copyDirectory((File)service, (File)tempFile);
    }

    public File getMuleHome() {
        return this.muleHome;
    }

    public File getLogsDir() {
        return this.logsDir;
    }

    public File getAppsDir() {
        return this.appsDir;
    }

    private File getDomainsDir() {
        return this.domainsDir;
    }

    public File getServerPluginsDir() {
        return this.serverPluginsDir;
    }

    public File getServicesDir() {
        return this.servicesDir;
    }

    public void resetDeploymentListener() {
        Mockito.reset((Object[])new DeploymentListener[]{this.deploymentListener});
    }

    public void addCoreExtension(MuleCoreExtension coreExtension) {
        coreExtension.setContainerClassLoader(this.containerClassLoader);
        this.coreExtensions.add(coreExtension);
    }

    public void addDeploymentListener(DeploymentListener listener) {
        this.deploymentService.addDeploymentListener(listener);
    }

    public void removeDeploymentListener(DeploymentListener listener) {
        this.deploymentService.removeDeploymentListener(listener);
    }

    public Application findApplication(String appName) {
        return this.deploymentService.findApplication(appName);
    }

    public Domain findDomain(String domainName) {
        return this.deploymentService.findDomain(domainName);
    }

    public void deployDomainFromClasspathFolder(String domainFolder, String domainName) throws URISyntaxException {
        this.copyExplodedArtifactFromClasspathFolderToDeployFolder(domainFolder, this.getDomainsDir(), domainName);
    }

    public void deployDomainFile(File domain) throws IOException {
        ReentrantLock lock = this.deploymentService.getLock();
        lock.lock();
        try {
            FileUtils.copyFile((File)domain, (File)new File(this.getDomainsDir(), domain.getName()));
        }
        finally {
            lock.unlock();
        }
        this.assertDeploymentSuccess(this.domainDeploymentListener, FilenameUtils.getBaseName((String)domain.getName()));
    }

    public void deployAppFromClasspathFolder(String appFolder, String appName) throws URISyntaxException {
        this.copyExplodedArtifactFromClasspathFolderToDeployFolder(appFolder, this.getAppsDir(), appName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyExplodedArtifactFromClasspathFolderToDeployFolder(String artifactFolderPath, File artifactDirectory, String artifactName) throws URISyntaxException {
        ReentrantLock lock = this.deploymentService.getLock();
        lock.lock();
        try {
            URL resource = this.getClass().getClassLoader().getResource(artifactFolderPath);
            File artifactFolder = new File(resource.toURI());
            this.copyExplodedArtifactFromFolderToDeployFolder(artifactFolder, artifactDirectory, artifactName);
        }
        finally {
            lock.unlock();
        }
    }

    private void copyExplodedArtifactFromFolderToDeployFolder(File artifactFolder, File artifactDirectory, String artifactName) {
        ReentrantLock lock = this.deploymentService.getLock();
        lock.lock();
        try {
            FileUtils.copyDirectory((File)artifactFolder, (File)new File(artifactDirectory, artifactName));
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    static {
        if (!Boolean.getBoolean(FAKE_SERVER_DISABLE_LOG_REPOSITORY_SELECTOR)) {
            System.setProperty("mule.simpleLog", "true");
        }
    }
}

