/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.deployment;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.mule.functional.services.TestServicesUtils;

public final class TestArtifactsCatalog
extends ExternalResource {
    public static Path schedulerServiceJarFile;
    public static Path httpServiceJarFile;
    public static Path expressionLanguageServiceJarFile;
    public static Path expressionLanguageMetadataServiceJarFile;
    private static TemporaryFolder compilerWorkFolder;

    public TestArtifactsCatalog(TemporaryFolder compilerWorkFolder) {
        TestArtifactsCatalog.compilerWorkFolder = compilerWorkFolder;
    }

    protected void before() throws Throwable {
        super.before();
        if (schedulerServiceJarFile != null) {
            return;
        }
        try {
            TestArtifactsCatalog.initFiles();
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static void initFiles() throws URISyntaxException, IOException {
        httpServiceJarFile = TestServicesUtils.buildHttpServiceFile((Path)compilerWorkFolder.newFolder("httpService").toPath());
        schedulerServiceJarFile = TestServicesUtils.buildSchedulerServiceFile((Path)compilerWorkFolder.newFolder("schedulerService").toPath());
        expressionLanguageServiceJarFile = TestServicesUtils.buildExpressionLanguageServiceFile((Path)compilerWorkFolder.newFolder("expressionLanguageService").toPath());
        expressionLanguageMetadataServiceJarFile = TestServicesUtils.buildExpressionLanguageMetadataServiceFile((Path)compilerWorkFolder.newFolder("expressionLanguageMetadataService").toPath());
    }
}

