/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.mule.test.infrastructure.process.AbstractOSController;
import org.mule.test.infrastructure.process.MuleControllerException;

public class WindowsController
extends AbstractOSController {
    protected static final String PID_WINDOWS = "(\\s)*PID (\\s)+ :(\\s)*([0-9])+";
    protected static final Pattern PID_PATTERN_WINDOWS = Pattern.compile("(\\s)*PID (\\s)+ :(\\s)*([0-9])+");

    public WindowsController(String muleHome, int timeout) {
        super(muleHome, timeout);
    }

    public WindowsController(String muleHome, int defaultTimeout, String locationSuffix) {
        super(muleHome, defaultTimeout, locationSuffix);
    }

    @Override
    public String getMuleBin() {
        return this.muleHome + "/bin/mule.bat";
    }

    @Override
    public void start(String ... args) {
        this.install(args);
        super.start(args);
        if (this.status(new String[0]) != 0) {
            throw new MuleControllerException("The mule instance couldn't be started");
        }
    }

    @Override
    public int stop(String ... args) {
        int returnCode = super.stop(args);
        int errorRemove = this.runSync("remove", new String[0]);
        if (errorRemove != 0 && errorRemove != 1060 && this.forceDeleteService() != 0) {
            throw new MuleControllerException("The mule instance couldn't be removed as a service");
        }
        return returnCode;
    }

    @Override
    public int getProcessId() {
        return this.getServiceList().stream().filter(this::isServiceRunning).map(this::getId).findAny().orElseThrow(() -> new MuleControllerException("No mule instance is running"));
    }

    private int getId(String serviceName) {
        String getServiceStatus = this.getServiceStatus(serviceName);
        Matcher matcher = PID_PATTERN_WINDOWS.matcher(getServiceStatus);
        if (!matcher.find()) {
            throw new MuleControllerException("PID pattern not recognized in " + getServiceStatus);
        }
        String result = matcher.group(0);
        String[] resultArray = result.split(": ");
        return Integer.parseInt(resultArray[1]);
    }

    @Override
    public int status(String ... args) {
        return this.getServiceList().stream().anyMatch(this::isServiceRunning) ? 0 : 1;
    }

    private List<String> getServiceList() {
        return StringUtils.isNotEmpty((CharSequence)this.muleAppName) ? Collections.singletonList(this.muleAppName) : Arrays.asList("mule", "mule_ee");
    }

    private boolean isServiceRunning(String serviceName) {
        return this.getServiceStatus(serviceName).contains("RUNNING");
    }

    private String getServiceStatus(String serviceName) {
        return this.executeCmd("sc queryex \"" + serviceName + "\" ");
    }

    private String executeCmd(String cmd) {
        StringBuilder output = new StringBuilder();
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = "";
            while ((line = reader.readLine()) != null) {
                output.append(line).append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output.toString();
    }

    private int forceDeleteService() {
        return this.getServiceList().stream().anyMatch(this::deleteService) ? 0 : 1;
    }

    private boolean deleteService(String serviceName) {
        return this.executeCmd("sc delete \"" + serviceName + "\" ").contains("SUCCESS");
    }

    @Override
    public void restart(String ... args) {
        this.install(args);
        super.restart(args);
    }

    private void install(String ... args) {
        int errorInstall = this.runSync("install", args);
        if (errorInstall != 0 && errorInstall != 1073) {
            throw new MuleControllerException("The mule instance couldn't be installed as a service");
        }
    }
}

