/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.deployment;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.mule.functional.services.TestServicesUtils;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.test.infrastructure.deployment.FakeMuleServer;

public class AbstractFakeMuleServerTestCase
extends AbstractMuleTestCase {
    @Rule
    public TemporaryFolder muleHome = new TemporaryFolder();
    @Rule
    public TemporaryFolder compilerWorkFolder = new TemporaryFolder();
    protected FakeMuleServer muleServer;

    protected List<MuleCoreExtension> getCoreExtensions() {
        return new LinkedList<MuleCoreExtension>();
    }

    @Before
    public void setUp() throws Exception {
        this.muleServer = new FakeMuleServer(this.muleHome.getRoot().getAbsolutePath(), this.getCoreExtensions());
        this.muleServer.addZippedService(TestServicesUtils.buildSchedulerServiceFile((File)this.compilerWorkFolder.newFolder("schedulerService")));
        this.muleServer.addZippedService(TestServicesUtils.buildHttpServiceFile((File)this.compilerWorkFolder.newFolder("httpService")));
        this.muleServer.addZippedService(TestServicesUtils.buildExpressionLanguageServiceFile((File)this.compilerWorkFolder.newFolder("expressionLanguageService")));
    }

    @After
    public void tearDown() throws Exception {
        if (this.muleServer != null) {
            this.muleServer.stop();
            this.muleServer = null;
        }
        LogManager.shutdown();
    }
}

