/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.maven;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.InvokerLogger;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.SystemOutLogger;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;

public class MavenTestUtils {
    private static final InvokerLogger LOGGER = new SystemOutLogger();
    private static final String M_2_REPO = "/.m2/repository";
    private static final String USER_HOME = "user.home";
    private static final URI MAVEN_ARTIFACTS_DIRECTORY = Optional.ofNullable(System.getProperty("mule.test.maven.artifacts.dir")).map(dir -> new File((String)dir).toURI()).orElseGet(() -> {
        try {
            return MavenTestUtils.class.getClassLoader().getResource("artifacts").toURI();
        }
        catch (URISyntaxException e) {
            LOGGER.error("Could not resolve default Maven artifacts directory", (Throwable)e);
            return null;
        }
    });
    private static final List<String> INSTALL_GOALS = Collections.singletonList("install");
    private static final List<String> CLEAN_GOALS = Collections.singletonList("clean");
    private static final File MAVEN_SETTINGS = new File(System.getProperty("settings.file"));

    private MavenTestUtils() {
    }

    public static File installMavenArtifact(String baseDirectory, BundleDescriptor descriptor) {
        return MavenTestUtils.installMavenArtifact(baseDirectory, descriptor, new Properties());
    }

    public static File installMavenArtifact(String baseDirectory, BundleDescriptor descriptor, Properties props) {
        MavenTestUtils.runMavenGoal(INSTALL_GOALS, baseDirectory, props);
        MavenTestUtils.runMavenGoal(CLEAN_GOALS, baseDirectory, props);
        return MavenTestUtils.findMavenArtifact(descriptor);
    }

    public static File findMavenArtifact(BundleDescriptor descriptor) {
        File artifact = new File(MavenTestUtils.getMavenLocalRepository(), Paths.get(descriptor.getGroupId().replaceAll("\\.", Matcher.quoteReplacement(File.separator)), descriptor.getArtifactId(), descriptor.getVersion(), descriptor.getArtifactFileName() + "." + descriptor.getType()).toString());
        if (!artifact.exists()) {
            LOGGER.error(String.format("Artifact file: %s", artifact.getAbsolutePath()));
            throw new IllegalArgumentException(String.format("Maven artifact '%s' does not exists in the local Maven repository @ '%s'", descriptor, MavenTestUtils.getMavenLocalRepository()));
        }
        return artifact;
    }

    public static File getMavenLocalRepository() {
        File mavenLocalRepositoryLocation;
        String buildDirectory = System.getProperty("localRepository");
        if (buildDirectory == null) {
            buildDirectory = System.getProperty(USER_HOME) + M_2_REPO;
        }
        if (!(mavenLocalRepositoryLocation = new File(buildDirectory)).exists()) {
            throw new IllegalArgumentException("Maven repository location couldn't be found, please check your configuration");
        }
        return mavenLocalRepositoryLocation;
    }

    private static void runMavenGoal(List<String> goals, String baseDirectory, Properties props) {
        DefaultInvoker invoker = new DefaultInvoker();
        invoker.setLocalRepositoryDirectory(MavenTestUtils.getMavenLocalRepository());
        invoker.setLogger(LOGGER);
        LOGGER.setThreshold(3);
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setGoals(goals);
        request.setBatchMode(true);
        request.setProperties(props);
        File baseDirFile = new File(baseDirectory);
        File mavenArtifactsAndBaseDirectory = baseDirFile.isAbsolute() ? baseDirFile : new File(new File(MAVEN_ARTIFACTS_DIRECTORY), baseDirectory);
        LOGGER.info("Using Maven artifacts base directory: '" + mavenArtifactsAndBaseDirectory.getAbsolutePath() + "'...");
        request.setBaseDirectory(mavenArtifactsAndBaseDirectory);
        request.setPomFile(new File(mavenArtifactsAndBaseDirectory, "pom.xml"));
        request.setShowErrors(true);
        request.setUserSettingsFile(MAVEN_SETTINGS);
        try {
            InvocationResult result = invoker.execute((InvocationRequest)request);
            if (result.getExitCode() != 0) {
                LOGGER.error("Error while running Maven invoker", (Throwable)result.getExecutionException());
                throw new RuntimeException("Error while running Maven invoker", (Throwable)result.getExecutionException());
            }
        }
        catch (MavenInvocationException e) {
            throw new RuntimeException("Error running Maven project: " + e.getMessage());
        }
    }

    public static BundleDescriptor getApplicationBundleDescriptor(String appName, Optional<String> classifier) {
        return new BundleDescriptor.Builder().setGroupId("test").setArtifactId(appName).setVersion("1.0.0").setClassifier(classifier.orElse("mule-application")).build();
    }

    public static BundleDescriptor getDomainBundleDescriptor(String appName) {
        return new BundleDescriptor.Builder().setGroupId("test").setArtifactId(appName).setVersion("1.0.0").setClassifier("mule-domain").build();
    }
}

