/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.deployment;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.mule.functional.services.TestServicesUtils;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.test.infrastructure.deployment.FakeMuleServer;

public class AbstractFakeMuleServerTestCase
extends AbstractMuleTestCase {
    @Rule
    public TemporaryFolder muleHome = new TemporaryFolder();
    @Rule
    public TemporaryFolder compilerWorkFolder = new TemporaryFolder();
    protected FakeMuleServer muleServer;

    protected List<MuleCoreExtension> getCoreExtensions() {
        return new LinkedList<MuleCoreExtension>();
    }

    @Before
    public void setUp() throws Exception {
        this.muleServer = new FakeMuleServer(this.muleHome.getRoot().getAbsolutePath(), this.getCoreExtensions());
        this.muleServer.addZippedService(this.getSchedulerService());
        this.muleServer.addZippedService(this.getHttpService());
        this.muleServer.addZippedService(this.getExpressionLanguageService());
    }

    @After
    public void tearDown() throws Exception {
        if (this.muleServer != null) {
            this.muleServer.stop();
            this.muleServer = null;
        }
        LogManager.shutdown();
    }

    protected File getExpressionLanguageService() throws IOException {
        return TestServicesUtils.buildExpressionLanguageServiceFile((File)this.compilerWorkFolder.newFolder("expressionLanguageService"));
    }

    protected File getSchedulerService() throws IOException {
        return TestServicesUtils.buildSchedulerServiceFile((File)this.compilerWorkFolder.newFolder("schedulerService"));
    }

    protected File getHttpService() throws IOException {
        return TestServicesUtils.buildHttpServiceFile((File)this.compilerWorkFolder.newFolder("httpService"));
    }
}

