/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.profiling.tracing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.mule.runtime.tracer.api.sniffer.CapturedEventData;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;

public class SpanTestHierarchy {
    public static final String LOCATION_KEY = "location";
    public static final String OTEL_EXCEPTION_TYPE_KEY = "exception.type";
    public static final String OTEL_EXCEPTION_MESSAGE_KEY = "exception.message";
    public static final String OTEL_EXCEPTION_STACK_TRACE_KEY = "exception.stacktrace";
    public static final String OTEL_EXCEPTION_ESCAPED_KEY = "exception.escaped";
    public static final String OTEL_EXCEPTION_EVENT_NAME = "exception";
    public static final String NO_EXCEPTION = "NONE";
    private SpanNode root;
    private SpanNode currentNode;
    private SpanNode lastChild;
    private static final String NO_PARENT_SPAN = "0000000000000000";
    private final HashSet<String> visitedSpans = new HashSet();
    private final HashMap<String, CapturedExportedSpan> spanHashMap = new HashMap();
    private final Collection<CapturedExportedSpan> actualExportedSpans;

    public SpanTestHierarchy(Collection<CapturedExportedSpan> actualExportedSpans) {
        this.actualExportedSpans = actualExportedSpans;
        actualExportedSpans.forEach(span -> this.spanHashMap.put(span.getSpanId(), (CapturedExportedSpan)span));
    }

    public SpanTestHierarchy withRoot(String rootName) {
        this.root = new SpanNode(rootName);
        this.root.parent = new SpanNode(NO_PARENT_SPAN);
        this.currentNode = this.root;
        return this;
    }

    public SpanTestHierarchy beginChildren() {
        this.lastChild = this.currentNode;
        return this;
    }

    public SpanTestHierarchy child(String childName) {
        SpanNode child = new SpanNode(childName);
        child.parent = this.lastChild;
        this.lastChild.addChild(child);
        this.currentNode = child;
        return this;
    }

    public SpanTestHierarchy endChildren() {
        if (this.currentNode != null && this.currentNode.parent != null) {
            this.lastChild = this.lastChild.parent;
            this.currentNode = this.currentNode.parent.parent;
        }
        return this;
    }

    public SpanTestHierarchy addAttributeToAssertValue(String key, String value) {
        this.currentNode.addAttributeThatShouldMatch(key, value);
        return this;
    }

    public SpanTestHierarchy addAttributesToAssertValue(Map<String, String> attributes) {
        this.currentNode.addAttributesThatShouldMatch(attributes);
        return this;
    }

    public SpanTestHierarchy addAttributesToAssertExistence(List<String> attributeNames) {
        this.currentNode.addAttributeThatShouldExist(attributeNames);
        return this;
    }

    public SpanTestHierarchy addAttributesToAssertExistence(String ... attributeNames) {
        this.currentNode.addAttributeThatShouldExist(Arrays.asList(attributeNames));
        return this;
    }

    public SpanTestHierarchy addExceptionData(String exceptionData) {
        this.currentNode.setExceptionData(exceptionData);
        return this;
    }

    public SpanTestHierarchy noExceptionExpected() {
        this.currentNode.setExceptionData(NO_EXCEPTION);
        return this;
    }

    public SpanNode getRoot() {
        return this.root;
    }

    public void assertSpanTree() {
        this.assertSpanTree(this.root, null);
    }

    private void assertSpanTree(SpanNode expectedNode, CapturedExportedSpan actualParent) {
        CapturedExportedSpan actualSpan = this.assertActualSpan(expectedNode, actualParent);
        for (SpanNode expectedChild : expectedNode.children) {
            this.assertSpanTree(expectedChild, actualSpan);
        }
    }

    private CapturedExportedSpan assertActualSpan(SpanNode expectedNode, CapturedExportedSpan actualParent) {
        CapturedExportedSpan actualSpan = this.actualExportedSpans.stream().filter(exportedSpan -> !this.visitedSpans.contains(exportedSpan.getSpanId()) && exportedSpan.getName().equals(expectedNode.spanName) && this.hasCorrectLocation((CapturedExportedSpan)exportedSpan, expectedNode.getAttribute(LOCATION_KEY)) && this.hasCorrectParent((CapturedExportedSpan)exportedSpan, actualParent != null ? actualParent.getName() : null)).findFirst().orElse(null);
        Assert.assertThat((String)("Expected span: " + expectedNode.spanName + " was not found"), (Object)actualSpan, (Matcher)Matchers.notNullValue());
        this.assertAttributes(actualSpan, expectedNode);
        this.assertException(actualSpan, expectedNode);
        this.visitedSpans.add(actualSpan.getSpanId());
        return actualSpan;
    }

    private boolean hasCorrectParent(CapturedExportedSpan span, String expectedParentName) {
        CapturedExportedSpan parentSpan = this.spanHashMap.get(span.getParentSpanId());
        if (expectedParentName != null && parentSpan == null) {
            return false;
        }
        if (expectedParentName == null && parentSpan == null) {
            return span.getParentSpanId().equals(NO_PARENT_SPAN);
        }
        return parentSpan.getName().equals(expectedParentName);
    }

    private boolean hasCorrectLocation(CapturedExportedSpan span, String expectedLocation) {
        return expectedLocation == null || ((String)span.getAttributes().get(LOCATION_KEY)).equals(expectedLocation);
    }

    private void assertAttributes(CapturedExportedSpan actualSpan, SpanNode expectedNode) {
        expectedNode.getAttributesThatShouldMatch().forEach((key, value) -> Assert.assertThat((String)("Actual attribute \"" + key + "\" for: " + expectedNode.spanName + " is not the expected one"), actualSpan.getAttributes().get(key), (Matcher)Matchers.equalTo((Object)value)));
        expectedNode.getAttributesThatShouldExist().forEach(attribute -> Assert.assertThat((String)("Actual attribute \"" + attribute + "\" for: " + expectedNode.spanName + " does not exist"), actualSpan.getAttributes().get(attribute), (Matcher)Matchers.notNullValue()));
    }

    private void assertException(CapturedExportedSpan actualSpan, SpanNode expectedNode) {
        if (expectedNode.getExceptionData() == null) {
            return;
        }
        if (expectedNode.getExceptionData().equals(NO_EXCEPTION)) {
            Assert.assertThat((String)String.format("Unexpected Span exceptions found for Span: [%s]", actualSpan), (Object)actualSpan.getEvents().size(), (Matcher)Matchers.equalTo((Object)0));
        } else {
            List exceptions = actualSpan.getEvents().stream().filter(capturedEventData -> capturedEventData.getName().equals(OTEL_EXCEPTION_EVENT_NAME)).collect(Collectors.toList());
            Assert.assertThat((String)String.format("Expected exceptions for Span: [%s] differ", actualSpan), (Object)exceptions.size(), (Matcher)Matchers.equalTo((Object)1));
            this.assertExceptionAttributes((CapturedEventData)exceptions.iterator().next(), expectedNode.getExceptionData());
            Assert.assertThat((Object)actualSpan.hasErrorStatus(), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    public void assertExceptionAttributes(CapturedEventData exceptionData, String errorType) {
        Assert.assertThat(exceptionData.getAttributes().get(OTEL_EXCEPTION_TYPE_KEY), (Matcher)CoreMatchers.equalTo((Object)errorType));
        Assert.assertThat(exceptionData.getAttributes().get(OTEL_EXCEPTION_MESSAGE_KEY), (Matcher)CoreMatchers.equalTo((Object)"An error occurred."));
        Assert.assertThat(exceptionData.getAttributes().get(OTEL_EXCEPTION_ESCAPED_KEY), (Matcher)CoreMatchers.equalTo((Object)"true"));
        Assert.assertThat((Object)exceptionData.getAttributes().get(OTEL_EXCEPTION_STACK_TRACE_KEY).toString(), (Matcher)CoreMatchers.not((Matcher)Matchers.emptyOrNullString()));
    }

    private static class SpanNode {
        private final String spanName;
        private SpanNode parent;
        private final List<SpanNode> children = new ArrayList<SpanNode>();
        private Map<String, String> attributesThatShouldMatch = new HashMap<String, String>();
        private List<String> attributesThatShouldExist = new ArrayList<String>();
        private String exceptionData;

        public SpanNode(String spanName) {
            this.spanName = spanName;
        }

        public void addChild(SpanNode child) {
            this.children.add(child);
        }

        public void addAttributeThatShouldMatch(String key, String value) {
            this.attributesThatShouldMatch.put(key, value);
        }

        public void addAttributesThatShouldMatch(Map<String, String> attributesThatShouldMatch) {
            this.attributesThatShouldMatch.putAll(attributesThatShouldMatch);
        }

        public void addAttributeThatShouldExist(List<String> attributes) {
            this.attributesThatShouldExist.addAll(attributes);
        }

        public void setExceptionData(String exceptionData) {
            this.exceptionData = exceptionData;
        }

        public String getAttribute(String key) {
            return this.attributesThatShouldMatch.get(key);
        }

        public Map<String, String> getAttributesThatShouldMatch() {
            return this.attributesThatShouldMatch;
        }

        public List<String> getAttributesThatShouldExist() {
            return this.attributesThatShouldExist;
        }

        public String getExceptionData() {
            return this.exceptionData;
        }
    }
}

