/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.deployment;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.mule.functional.services.TestServicesUtils;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.infrastructure.deployment.FakeMuleServer;

public class AbstractFakeMuleServerTestCase
extends AbstractMuleTestCase {
    @Rule
    public SystemProperty jvmVersionExtensionEnforcementLoose = new SystemProperty("mule.jvm.version.extension.enforcement", "LOOSE");
    @Rule
    public SystemProperty classloaderContainerJpmsModuleLayer = new SystemProperty("mule.classloader.container.jpmsModuleLayer", "false");
    @Rule
    public TemporaryFolder muleHome = new TemporaryFolder();
    @ClassRule
    public static final TemporaryFolder compilerWorkFolder = new TemporaryFolder();
    private static boolean areServicesInitialised = false;
    private static File cachedSchedulerService = null;
    private static File cachedHttpService = null;
    private static File cachedELService = null;
    private static File cachedELMService = null;
    protected FakeMuleServer muleServer;

    protected List<MuleCoreExtension> getCoreExtensions() {
        return new LinkedList<MuleCoreExtension>();
    }

    @Before
    public void setUp() throws Exception {
        this.muleServer = new FakeMuleServer(this.muleHome.getRoot().getAbsolutePath(), this.getCoreExtensions());
        this.initialiseServicesIfNeeded();
        this.muleServer.addZippedService(cachedSchedulerService);
        this.muleServer.addZippedService(cachedHttpService);
        this.muleServer.addZippedService(cachedELService);
        if (this.addExpressionLanguageMetadataService()) {
            this.muleServer.addZippedService(cachedELMService);
        }
    }

    protected boolean addExpressionLanguageMetadataService() {
        return true;
    }

    @After
    public void tearDown() throws Exception {
        if (this.muleServer != null) {
            this.muleServer.stop();
            this.muleServer = null;
        }
        LogManager.shutdown();
    }

    private void initialiseServicesIfNeeded() throws IOException {
        if (!areServicesInitialised) {
            areServicesInitialised = true;
            cachedSchedulerService = this.getSchedulerService();
            cachedHttpService = this.getHttpService();
            cachedELService = this.getExpressionLanguageService();
            if (this.addExpressionLanguageMetadataService()) {
                cachedELMService = this.getExpressionLanguageMetadataService();
            }
        }
    }

    @AfterClass
    public static void nullifyCachedServices() {
        areServicesInitialised = false;
        cachedSchedulerService = null;
        cachedHttpService = null;
        cachedELService = null;
        cachedELMService = null;
    }

    protected File getExpressionLanguageService() throws IOException {
        return TestServicesUtils.buildExpressionLanguageServiceFile((File)compilerWorkFolder.newFolder("expressionLanguageService"));
    }

    protected File getExpressionLanguageMetadataService() throws IOException {
        return TestServicesUtils.buildExpressionLanguageMetadataServiceFile((File)compilerWorkFolder.newFolder("expressionLanguageMetadataService"));
    }

    protected File getSchedulerService() throws IOException {
        return TestServicesUtils.buildSchedulerServiceFile((File)compilerWorkFolder.newFolder("schedulerService"));
    }

    protected File getHttpService() throws IOException {
        return TestServicesUtils.buildHttpServiceFile((File)compilerWorkFolder.newFolder("httpService"));
    }
}

