/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process.rules;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.mule.test.infrastructure.process.MuleProcessController;
import org.mule.test.infrastructure.process.rules.MuleInstallation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleServerFailureLogger
extends TestWatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleServerFailureLogger.class);
    private final MuleInstallation installation;

    public MuleServerFailureLogger(MuleInstallation installation) {
        this.installation = installation;
    }

    protected void failed(Throwable e, Description description) {
        String serverLog = new MuleProcessController(this.installation.getMuleHome()).getLog().getAbsolutePath();
        try (Stream<String> stream = Files.lines(Paths.get(serverLog, new String[0]));){
            LOGGER.error("====================== Server log ===============================");
            stream.forEach(arg_0 -> ((Logger)LOGGER).error(arg_0));
            LOGGER.error("=================================================================");
        }
        catch (IOException e1) {
            LOGGER.error("Failed to log server log");
        }
    }
}

