/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.lang3.StringUtils;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.infrastructure.process.MuleControllerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOSController {
    private static final long TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(60L);
    private static final long POLL_DELAY_MILLIS = 500L;
    protected static final String START_CMD = "start";
    protected static final String STOP_CMD = "stop";
    protected static final String DUMP_CMD = "dump";
    protected static final String RESTART_CMD = "restart";
    protected static final String STATUS_CMD = "status";
    private static final Logger logger = LoggerFactory.getLogger(AbstractOSController.class);
    protected static final String STATUS_PID_GROUP_NAME = "pid";
    protected static final String STATUS_WRAPPER_GROUP_NAME = "wrapper";
    protected static final String STATUS_JAVA_GROUP_NAME = "java";
    protected static final String STATUS_LABELS = String.format("Mule(?:(\\sEnterprise Edition)? \\(standalone\\))? is running:\\sPID:(?<%s>[0-9]+), Wrapper:(?<%s>\\w+), Java:(?<%s>\\w+)", "pid", "wrapper", "java");
    protected static final Pattern STATUS_LABELS_PATTERN = Pattern.compile(STATUS_LABELS);
    private static final int DEFAULT_TIMEOUT = 30000;
    private static final String MULE_HOME_VARIABLE = "MULE_HOME";
    private static final String MULE_APP_VARIABLE = "MULE_APP";
    private static final String MULE_APP_LONG_VARIABLE = "MULE_APP_LONG";
    protected static final String MULE_SERVICE_NAME = "mule";
    protected static final String MULE_EE_SERVICE_NAME = "mule_ee";
    protected final String muleHome;
    protected final String muleAppName;
    protected final String muleAppLongName;
    protected final String muleBin;
    protected final int timeout;
    protected Map<String, String> testEnvVars;

    public AbstractOSController(String muleHome, int timeout) {
        this.muleHome = muleHome;
        this.muleBin = this.getMuleBin();
        this.timeout = timeout != 0 ? timeout : 30000;
        this.muleAppName = null;
        this.muleAppLongName = null;
    }

    public AbstractOSController(String muleHome, int timeout, String locationSuffix) {
        this.muleHome = muleHome;
        this.muleBin = this.getMuleBin();
        this.timeout = timeout != 0 ? timeout : 30000;
        this.muleAppName = "mule_ee_node_" + locationSuffix;
        this.muleAppLongName = "MuleEnterpriseEditionNode" + locationSuffix;
    }

    public String getMuleHome() {
        return this.muleHome;
    }

    public abstract String getMuleBin();

    public void setTestEnvVars(Map<String, String> testEnvVars) {
        this.testEnvVars = testEnvVars;
    }

    public void start(String ... args) {
        int error = this.runSync(START_CMD, args);
        if (error != 0) {
            throw new MuleControllerException("The mule instance couldn't be started. Errno: " + error);
        }
        final AtomicReference status = new AtomicReference();
        Probe probe = new Probe(){

            public boolean isSatisfied() {
                MuleProcessStatus currentStatus = AbstractOSController.this.getProcessesStatus();
                status.set(currentStatus);
                return currentStatus == MuleProcessStatus.STARTED_STARTED;
            }

            public String describeFailure() {
                return String.format("The mule instance didn't start on time: %s", status.get());
            }
        };
        if (!new PollingProber(TIMEOUT_MILLIS, 500L).poll(probe)) {
            this.runSync(DUMP_CMD, new String[0]);
            throw new MuleControllerException(probe.describeFailure());
        }
    }

    public int stop(String ... args) {
        return this.runSync(STOP_CMD, args);
    }

    public abstract int status(String ... var1);

    public abstract int getProcessId();

    public abstract MuleProcessStatus getProcessesStatus();

    public String getMuleAppName() {
        return this.muleAppName;
    }

    public void restart(String ... args) {
        int error = this.runSync(RESTART_CMD, args);
        if (error != 0) {
            throw new MuleControllerException("The mule instance couldn't be restarted");
        }
    }

    protected int runSync(String command, String ... args) {
        CommandLine commandLine = new CommandLine(this.muleBin);
        commandLine.addArgument(command);
        commandLine.addArguments(args, false);
        return this.runSync(commandLine, null);
    }

    protected int runSync(CommandLine commandLine, ExecuteStreamHandler streamHandler) {
        Map<String, String> newEnv = this.copyEnvironmentVariables();
        return this.executeSyncCommand(commandLine, newEnv, streamHandler, this.timeout);
    }

    protected Process runAsync(CommandLine commandLine, ExecuteStreamHandler streamHandler) {
        Map<String, String> newEnv = this.copyEnvironmentVariables();
        return this.executeAsyncCommand(commandLine, newEnv, streamHandler);
    }

    private int executeSyncCommand(CommandLine commandLine, Map<String, String> newEnv, ExecuteStreamHandler streamHandler, int timeout) {
        DefaultExecutor executor = new DefaultExecutor();
        ExecuteWatchdog watchdog = new ExecuteWatchdog((long)timeout);
        executor.setWatchdog(watchdog);
        this.setStreamHandler((Executor)executor, streamHandler);
        return this.doExecution((Executor)executor, commandLine, newEnv);
    }

    private Process executeAsyncCommand(CommandLine commandLine, Map<String, String> newEnv, ExecuteStreamHandler streamHandler) {
        ProcessCapturingExecutor executor = new ProcessCapturingExecutor();
        this.setStreamHandler((Executor)executor, streamHandler);
        this.doAsyncExecution((Executor)executor, commandLine, newEnv);
        return executor.getProcess();
    }

    private void setStreamHandler(Executor executor, ExecuteStreamHandler streamHandler) {
        if (streamHandler == null) {
            streamHandler = new PumpStreamHandler((OutputStream)new ByteArrayOutputStream());
        }
        executor.setStreamHandler(streamHandler);
    }

    protected int doExecution(Executor executor, CommandLine commandLine, Map<String, String> env) {
        String maskedCommandLine = this.getMaskedCommandLineForLogging(commandLine);
        try {
            logger.info("Executing: {}", (Object)maskedCommandLine);
            return executor.execute(commandLine, env);
        }
        catch (ExecuteException e) {
            logger.error("Error executing {}", (Object)maskedCommandLine);
            return e.getExitValue();
        }
        catch (Exception e) {
            throw new MuleControllerException(String.format("Error executing [%s]", maskedCommandLine), e);
        }
    }

    private void doAsyncExecution(Executor executor, CommandLine commandLine, Map<String, String> env) {
        String maskedCommandLine = this.getMaskedCommandLineForLogging(commandLine);
        try {
            logger.info("Executing: {}", (Object)maskedCommandLine);
            executor.execute(commandLine, env, (ExecuteResultHandler)new DefaultExecuteResultHandler());
        }
        catch (ExecuteException e) {
            logger.error("Error executing {}", (Object)maskedCommandLine);
        }
        catch (Exception e) {
            throw new MuleControllerException(String.format("Error executing [%s]", maskedCommandLine), e);
        }
    }

    private String getMaskedCommandLineForLogging(CommandLine commandLine) {
        StringJoiner paramsJoiner = new StringJoiner(" ");
        for (String cmdArg : commandLine.toStrings()) {
            paramsJoiner.add(cmdArg.replaceAll("(?<=\\.password=)(.*)", "****"));
        }
        return paramsJoiner.toString();
    }

    protected Map<String, String> copyEnvironmentVariables() {
        HashMap<String, String> newEnv = new HashMap<String, String>();
        if (this.testEnvVars != null) {
            newEnv.putAll(this.testEnvVars);
        } else {
            newEnv.putAll(System.getenv());
        }
        newEnv.put(MULE_HOME_VARIABLE, this.muleHome);
        if (StringUtils.isNotEmpty((CharSequence)this.muleAppName) && StringUtils.isNotEmpty((CharSequence)this.muleAppLongName)) {
            newEnv.put(MULE_APP_VARIABLE, this.muleAppName);
            newEnv.put(MULE_APP_LONG_VARIABLE, this.muleAppLongName);
        }
        return newEnv;
    }

    private static class ProcessCapturingExecutor
    extends DefaultExecutor {
        private final CompletableFuture<Process> processFuture = new CompletableFuture();

        private ProcessCapturingExecutor() {
        }

        protected Process launch(CommandLine command, Map<String, String> env, File dir) throws IOException {
            Process process = super.launch(command, env, dir);
            this.processFuture.complete(process);
            return process;
        }

        public Process getProcess() {
            try {
                return this.processFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new MuleControllerException(e.getCause());
            }
        }
    }

    public static enum MuleProcessStatus {
        STARTING_STARTING,
        STARTED_STARTING,
        STARTED_STARTED,
        STARTING_LAUNCH,
        STARTING_LAUNCHING;

    }
}

