/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.profiling.tracing;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.mule.runtime.tracer.api.sniffer.CapturedEventData;

public class ExceptionEventMatcher
extends TypeSafeMatcher<CapturedEventData> {
    public static final String OTEL_EXCEPTION_EVENT_NAME = "exception";
    public static final String OTEL_EXCEPTION_TYPE_KEY = "exception.type";
    public static final String OTEL_EXCEPTION_MESSAGE_KEY = "exception.message";
    public static final String OTEL_EXCEPTION_STACK_TRACE_KEY = "exception.stacktrace";
    public static final String OTEL_EXCEPTION_ESCAPED_KEY = "exception.escaped";
    private final Matcher<String> eventNameMatcher = CoreMatchers.equalTo((Object)"exception");
    private final Matcher<String> exceptionTypeMatcher;
    private Matcher<String> exceptionDescriptionMatcher;
    private final Matcher<String> exceptionEscapedMatcher = CoreMatchers.equalTo((Object)"true");
    private Matcher<String> exceptionStackTraceMatcher = CoreMatchers.not((Matcher)Matchers.emptyOrNullString());

    private ExceptionEventMatcher(String errorType) {
        this.exceptionTypeMatcher = CoreMatchers.equalTo((Object)errorType);
        this.exceptionDescriptionMatcher = Matchers.any(String.class);
    }

    public static ExceptionEventMatcher withType(String type) {
        return new ExceptionEventMatcher(type);
    }

    public ExceptionEventMatcher withStackTrace(String stackTrace) {
        this.exceptionStackTraceMatcher = CoreMatchers.equalTo((Object)stackTrace);
        return this;
    }

    public ExceptionEventMatcher withDescription(String description) {
        this.exceptionDescriptionMatcher = CoreMatchers.equalTo((Object)description);
        return this;
    }

    protected boolean matchesSafely(CapturedEventData event) {
        return this.eventNameMatcher.matches((Object)event.getName()) && this.exceptionDescriptionMatcher.matches(event.getAttributes().get(OTEL_EXCEPTION_MESSAGE_KEY)) && this.exceptionEscapedMatcher.matches(event.getAttributes().get(OTEL_EXCEPTION_ESCAPED_KEY)) && this.exceptionStackTraceMatcher.matches(event.getAttributes().get(OTEL_EXCEPTION_STACK_TRACE_KEY)) && this.exceptionTypeMatcher.matches(event.getAttributes().get(OTEL_EXCEPTION_TYPE_KEY));
    }

    public void describeTo(Description description) {
        description.appendText("event: {name: \"exception\", type: ").appendDescriptionOf(this.exceptionTypeMatcher).appendText(", description: ").appendDescriptionOf(this.exceptionDescriptionMatcher).appendText(", stacktrace: ").appendDescriptionOf(this.exceptionStackTraceMatcher).appendText(", escaped: ").appendDescriptionOf(this.exceptionEscapedMatcher).appendText("}");
    }
}

