/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process;

import java.io.File;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.mule.test.infrastructure.process.AbstractOSController;
import org.mule.test.infrastructure.process.Controller;
import org.mule.test.infrastructure.process.UnixController;
import org.mule.test.infrastructure.process.WindowsController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleProcessController {
    public static final String MULE_PARAM_PROPERTY_PREFIX = "mule.test.muleParam.";
    private static final String DEBUG_WRAPER_PROPERTY = "mule.test.wrapperDebug";
    private static final Logger LOGGER_WRAPPER = LoggerFactory.getLogger((String)(MuleProcessController.class.getName() + ".wrapper"));
    private static final int DEFAULT_TIMEOUT = 60000;
    private final Controller controller;

    public MuleProcessController(String muleHome) {
        this(muleHome, 60000);
    }

    public MuleProcessController(String muleHome, int timeout) {
        AbstractOSController osSpecificController = SystemUtils.IS_OS_WINDOWS ? new WindowsController(muleHome, timeout) : new UnixController(muleHome, timeout);
        this.controller = this.buildController(muleHome, osSpecificController);
    }

    public MuleProcessController(String muleHome, String locationSuffix) {
        AbstractOSController osSpecificController = SystemUtils.IS_OS_WINDOWS ? new WindowsController(muleHome, 60000, locationSuffix) : new UnixController(muleHome, 60000);
        this.controller = this.buildController(muleHome, osSpecificController);
    }

    protected Controller buildController(String muleHome, AbstractOSController osSpecificController) {
        return new Controller(osSpecificController, muleHome);
    }

    public boolean isRunning() {
        return this.getController().isRunning();
    }

    public int installAgent(String consoleURI, String serverName, String token) {
        return this.getController().installAgent(serverName, consoleURI, token);
    }

    public void start(String ... baseArgs) {
        String[] args = baseArgs;
        Map<String, String> additionalMuleParamsProperties = System.getProperties().entrySet().stream().filter(e -> e.getKey().toString().startsWith(MULE_PARAM_PROPERTY_PREFIX)).collect(Collectors.toMap(e -> e.getKey().toString().substring(MULE_PARAM_PROPERTY_PREFIX.length()), e -> e.getValue().toString()));
        if (LOGGER_WRAPPER.isDebugEnabled() || Boolean.getBoolean(DEBUG_WRAPER_PROPERTY)) {
            additionalMuleParamsProperties.put("wrapperDebug", "");
        }
        if (!additionalMuleParamsProperties.isEmpty()) {
            args = (String[])Stream.concat(Stream.of(args), additionalMuleParamsProperties.entrySet().stream().map(e -> (String)e.getKey() + (String)(StringUtils.isEmpty((CharSequence)((CharSequence)e.getValue())) ? "" : "=" + (String)e.getValue()))).toArray(String[]::new);
        }
        this.getController().start(args);
    }

    public void stop(String ... args) {
        this.getController().stop(args);
    }

    public int status(String ... args) {
        return this.getController().status(args);
    }

    public int getProcessId() {
        return this.getController().getProcessId();
    }

    public void restart(String ... args) {
        this.getController().restart(args);
    }

    public void deploy(String path) {
        this.getController().deploy(path);
    }

    public void redeploy(String application) {
        this.getController().redeploy(application);
    }

    public boolean isDeployed(String appName) {
        return this.getController().isDeployed(appName);
    }

    public boolean wasRemoved(String appName) {
        return this.getController().wasRemoved(appName);
    }

    public File getArtifactInternalRepository(String artifactName) {
        return this.getController().getArtifactInternalRepository(artifactName);
    }

    public File getRuntimeInternalRepository() {
        return this.getController().getRuntimeInternalRepository();
    }

    public boolean isDomainDeployed(String domainName) {
        return this.getController().isDomainDeployed(domainName);
    }

    public void undeploy(String application) {
        this.getController().undeploy(application);
    }

    public void undeployDomain(String domain) {
        this.getController().undeployDomain(domain);
    }

    public void undeployAll() {
        this.getController().undeployAll();
    }

    public void installLicense(String path) {
        this.getController().installLicense(path);
    }

    public void uninstallLicense() {
        this.getController().uninstallLicense();
    }

    public void verifyLicenseDetails(String path) {
        this.getController().verifyLicenseDetails(path);
    }

    public void addLibrary(File jar) {
        this.getController().addLibrary(jar);
    }

    public void deployDomain(String domain) {
        this.getController().deployDomain(domain);
    }

    public void deployDomainBundle(String domain) {
        this.getController().deployDomainBundle(domain);
    }

    public File getLog() {
        return this.getController().getLog();
    }

    public File getLog(String appName) {
        return this.getController().getLog(appName);
    }

    public void addConfProperty(String value) {
        this.getController().addConfProperty(value);
    }

    public void useLog4jConfigFile(File log4jFile) {
        this.getController().useLog4jConfigFile(log4jFile);
    }

    protected Controller getController() {
        return this.controller;
    }

    public void setTestEnvVars(Map<String, String> testEnvVars) {
        this.getController().setTestEnvVars(testEnvVars);
    }
}

