/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.junit4.AbstractConfigurationFailuresTestCase;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.test.heisenberg.extension.HeisenbergExtension;

@Feature(value="Error Handling")
@Story(value="Mule DSL Validations")
public class ErrorHandlingConfigurationFailuresTestCase
extends AbstractConfigurationFailuresTestCase {
    @Test
    public void defaultErrorHandlerReferencesNonExistentErrorHandler() throws Exception {
        ConfigurationException thrown = (ConfigurationException)Assert.assertThrows(ConfigurationException.class, () -> this.loadConfiguration("org/mule/test/integration/exceptions/default-error-handler-reference-non-existent-es.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"No global error handler defined with name 'nonExistentEh'."));
    }

    @Test
    public void xaTransactionalTryNotAllowed() throws Exception {
        InitialisationException thrown = (InitialisationException)Assert.assertThrows(InitialisationException.class, () -> this.loadConfiguration("org/mule/test/integration/transaction/xa-transactional-try-config.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"Unable to create Try Scope with a Transaction Type: [XA]"));
    }

    @Test
    public void xaTransactionalTryNotAllowedWithGlobalErrorHandler() throws Exception {
        InitialisationException thrown = (InitialisationException)Assert.assertThrows(InitialisationException.class, () -> this.loadConfiguration("org/mule/test/integration/transaction/xa-transactional-try-config-global-err.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"Unable to create Try Scope with a Transaction Type: [XA]"));
    }

    @Test
    public void unknownErrorFilteringNotAllowed() throws Exception {
        ConfigurationException thrown = (ConfigurationException)Assert.assertThrows(ConfigurationException.class, () -> this.loadConfiguration("org/mule/test/integration/exceptions/unknown-error-filtering-config.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)this.notFound("UNKNOWN")));
    }

    @Test
    public void sourceErrorResponseFilteringNotAllowed() throws Exception {
        ConfigurationException thrown = (ConfigurationException)Assert.assertThrows(ConfigurationException.class, () -> this.loadConfiguration("org/mule/test/integration/exceptions/source-error-response-filtering-config.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)this.notFound("SOURCE")));
    }

    @Test
    public void raisesErrorEmptyErrorTypeNotAllowed() throws Exception {
        ConfigurationException thrown = (ConfigurationException)Assert.assertThrows(ConfigurationException.class, () -> this.loadConfiguration("org/mule/test/integration/exceptions/raise-error-empty-type-config.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"The value '' of attribute 'type' on element 'raise-error' is not valid with respect to its type, 'nonBlankString'"));
    }

    @Test
    @Issue(value="W-11802232")
    public void raisesErrorPropertyErrorTypeNotAllowed() throws Exception {
        ConfigurationException thrown = (ConfigurationException)Assert.assertThrows(ConfigurationException.class, () -> this.loadConfiguration("org/mule/test/integration/exceptions/raise-error-property-type-config.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"Couldn't find configuration property value for key ${error.type}"));
    }

    @Test
    public void sourceErrorResponseSendFilteringNotAllowed() throws Exception {
        ConfigurationException thrown = (ConfigurationException)Assert.assertThrows(ConfigurationException.class, () -> this.loadConfiguration("org/mule/test/integration/exceptions/source-error-response-send-filtering-config.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)this.notFound("SOURCE_ERROR_RESPONSE_SEND")));
    }

    @Test
    public void sourceErrorResponseGenerateFilteringNotAllowed() throws Exception {
        ConfigurationException thrown = (ConfigurationException)Assert.assertThrows(ConfigurationException.class, () -> this.loadConfiguration("org/mule/test/integration/exceptions/source-error-response-generate-filtering-config.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)this.notFound("SOURCE_ERROR_RESPONSE_GENERATE")));
    }

    @Test
    public void criticalErrorFilteringNotAllowed() throws Exception {
        ConfigurationException thrown = (ConfigurationException)Assert.assertThrows(ConfigurationException.class, () -> this.loadConfiguration("org/mule/test/integration/exceptions/critical-error-filtering-config.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)this.notFound("CRITICAL")));
    }

    @Test
    public void nonExistingSourceMappingNotAllowed() throws Exception {
        ConfigurationException thrown = (ConfigurationException)Assert.assertThrows(ConfigurationException.class, () -> this.loadConfiguration("org/mule/test/integration/exceptions/non-existing-source-mapping-config.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"Could not find error 'NON_EXISTING'"));
    }

    @Test
    public void nonExistingCoreMappingsNotAllowed() throws Exception {
        ConfigurationException thrown = (ConfigurationException)Assert.assertThrows(ConfigurationException.class, () -> this.loadConfiguration("org/mule/test/integration/exceptions/non-existent-core-mapping-config.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"There's no MULE error named 'NON_EXISTING'"));
    }

    @Test
    @Issue(value="W-11802232")
    public void propertyErrorMappingsSourceNotAllowed() throws Exception {
        ConfigurationException thrown = (ConfigurationException)Assert.assertThrows(ConfigurationException.class, () -> this.loadConfiguration("org/mule/test/integration/exceptions/property-error-mapping-source-config.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"Couldn't find configuration property value for key ${error.type}"));
    }

    @Test
    @Issue(value="W-11802232")
    public void propertyErrorMappingsTargetNotAllowed() throws Exception {
        ConfigurationException thrown = (ConfigurationException)Assert.assertThrows(ConfigurationException.class, () -> this.loadConfiguration("org/mule/test/integration/exceptions/property-error-mapping-target-config.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"Couldn't find configuration property value for key ${error.type}"));
    }

    @Test
    public void usedNamespaceMappingsNotAllowed() throws Exception {
        ConfigurationException thrown = (ConfigurationException)Assert.assertThrows(ConfigurationException.class, () -> this.loadConfiguration("org/mule/test/integration/exceptions/used-namespace-mappings-config.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"Cannot use error type 'HEISENBERG:HEALTH': namespace already exists"));
    }

    @Test
    public void usedNamespaceNonExistentTypeMappingsNotAllowed() throws Exception {
        ConfigurationException thrown = (ConfigurationException)Assert.assertThrows(ConfigurationException.class, () -> this.loadConfiguration("org/mule/test/integration/exceptions/used-namespace-nonexistent-type-mappings-config.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"Cannot use error type 'HEISENBERG:NONEXISTENT': namespace already exists"));
    }

    @Test
    public void nonExistingCoreErrorCannotBeRaised() throws Exception {
        ConfigurationException thrown = (ConfigurationException)Assert.assertThrows(ConfigurationException.class, () -> this.loadConfiguration("org/mule/test/integration/exceptions/non-existent-core-raise-error-config.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"There's no MULE error named 'NONEXISTENT'"));
    }

    @Test
    public void usedNamespaceErrorCannotBeRaised() throws Exception {
        ConfigurationException thrown = (ConfigurationException)Assert.assertThrows(ConfigurationException.class, () -> this.loadConfiguration("org/mule/test/integration/exceptions/used-namespace-raise-error-config.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"Cannot use error type 'HEISENBERG:HEALTH': namespace already exists"));
    }

    @Test
    public void usedNamespaceNonExistentTypeErrorCannotBeRaised() throws Exception {
        ConfigurationException thrown = (ConfigurationException)Assert.assertThrows(ConfigurationException.class, () -> this.loadConfiguration("org/mule/test/integration/exceptions/used-namespace-nonexistent-type-raise-error-config.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"Cannot use error type 'HEISENBERG:NONEXISTENT': namespace already exists."));
    }

    @Test
    public void sourceResponseGenerateOnErrorContinue() throws Exception {
        InitialisationException thrown = (InitialisationException)Assert.assertThrows(InitialisationException.class, () -> this.loadConfiguration("org/mule/test/integration/exceptions/on-error-continue-response-generate.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.equalTo((Object)this.notAllowed("SOURCE_RESPONSE_GENERATE")));
    }

    @Test
    public void sourceResponseSendOnErrorContinue() throws Exception {
        InitialisationException thrown = (InitialisationException)Assert.assertThrows(InitialisationException.class, () -> this.loadConfiguration("org/mule/test/integration/exceptions/on-error-continue-response-send.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.equalTo((Object)this.notAllowed("SOURCE_RESPONSE_SEND")));
    }

    @Test
    public void sourceResponseErrorOnErrorContinue() throws Exception {
        InitialisationException thrown = (InitialisationException)Assert.assertThrows(InitialisationException.class, () -> this.loadConfiguration("org/mule/test/integration/exceptions/on-error-continue-response-error.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.equalTo((Object)this.notAllowed("SOURCE_RESPONSE")));
    }

    @Test
    public void sourceErrorInListOnErrorContinue() throws Exception {
        InitialisationException thrown = (InitialisationException)Assert.assertThrows(InitialisationException.class, () -> this.loadConfiguration("org/mule/test/integration/exceptions/on-error-continue-source-error-list.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.equalTo((Object)this.notAllowed("SOURCE_RESPONSE")));
    }

    private String notFound(String type) {
        return String.format("Could not find error '%s'", type);
    }

    private String notAllowed(String type) {
        return String.format("Source errors are not allowed in 'on-error-continue' handlers. Offending type is '%s'.", type);
    }

    protected List<ExtensionModel> getRequiredExtensions() {
        ExtensionModel heisenberg = this.loadExtension(HeisenbergExtension.class, Collections.emptySet());
        ArrayList<ExtensionModel> extensions = new ArrayList<ExtensionModel>();
        extensions.addAll(super.getRequiredExtensions());
        extensions.add(heisenberg);
        return extensions;
    }

    protected void applyConfiguration(DefaultMuleConfiguration muleConfiguration) {
        super.applyConfiguration(muleConfiguration);
        muleConfiguration.setMinMuleVersion(new MuleVersion("4.5.0"));
    }
}

