/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.processors;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.functional.junit4.AbstractConfigurationFailuresTestCase;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;

@Feature(value="Core Components")
@Stories(value={@Story(value="Parse Template"), @Story(value="Mule DSL Validations")})
@RunWith(value=Parameterized.class)
public class RequiredExpressionsFailuresTestCase
extends AbstractConfigurationFailuresTestCase {
    public MuleVersion minMuleVersion;
    @Rule
    public ExpectedException expectedException;

    @Parameterized.Parameters(name="version: {0}")
    public static Collection<Object[]> featureFlags() {
        ExpectedException expected = ExpectedException.none();
        expected.expect(ConfigurationException.class);
        expected.expectMessage(Matchers.containsString((String)"A static value ('not_an_expression') was given for parameter 'targetValue' but it requires an expression"));
        return Arrays.asList({"4.5.0", expected}, {"4.4.0", ExpectedException.none()});
    }

    public RequiredExpressionsFailuresTestCase(String minMuleVersion, ExpectedException expectedException) {
        this.minMuleVersion = new MuleVersion(minMuleVersion);
        this.expectedException = expectedException;
    }

    @Test
    @Issue(value="MULE-19987")
    public void withWrongTargetValue() throws Exception {
        this.loadConfiguration("org/mule/processors/parse-template-wrong-target-value-config.xml");
    }

    protected void applyConfiguration(DefaultMuleConfiguration muleConfiguration) {
        super.applyConfiguration(muleConfiguration);
        muleConfiguration.setMinMuleVersion(this.minMuleVersion);
    }
}

