/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsIterableContaining;
import org.junit.Test;
import org.mule.functional.junit4.AbstractConfigurationWarningsBeforeDeploymentTestCase;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.test.heisenberg.extension.HeisenbergExtension;

@Feature(value="Error Handling")
@Story(value="Mule DSL Validations")
public class ErrorHandlingConfigurationWarningsBeforeDeploymentTestCase
extends AbstractConfigurationWarningsBeforeDeploymentTestCase {
    @Test
    @Issue(value="W-11802232")
    public void raisesErrorPropertyErrorTypeNotAllowed() throws Exception {
        this.loadConfiguration("org/mule/test/integration/exceptions/raise-error-property-type-config.xml");
        MatcherAssert.assertThat((Object)this.getWarningMessages(), (Matcher)IsIterableContaining.hasItem((Object)"'raise-error' has 'type' '${error.type}' which is resolved with a property and may cause the artifact to have different behavior on different environments."));
    }

    @Test
    @Issue(value="W-11802232")
    public void propertyTargetErrorMappingsNotAllowed() throws Exception {
        this.loadConfiguration("org/mule/test/integration/exceptions/property-error-mapping-target-config.xml");
        MatcherAssert.assertThat((Object)this.getWarningMessages(), (Matcher)IsIterableContaining.hasItem((Object)"'cure-cancer' has 'type' '${error.type}' which is resolved with a property and may cause the artifact to have different behavior on different environments."));
    }

    @Test
    @Issue(value="W-11802232")
    public void propertySourceErrorMappingsNotAllowed() throws Exception {
        this.loadConfiguration("org/mule/test/integration/exceptions/property-error-mapping-source-config.xml");
        MatcherAssert.assertThat((Object)this.getWarningMessages(), (Matcher)IsIterableContaining.hasItem((Object)"'cure-cancer' has 'type' '${error.type}' which is resolved with a property and may cause the artifact to have different behavior on different environments."));
    }

    @Test
    @Issue(value="W-11802232")
    public void propertyOnErrorNotAllowed() throws Exception {
        this.loadConfiguration("org/mule/test/integration/exceptions/property-on-error-config.xml");
        MatcherAssert.assertThat((Object)this.getWarningMessages(), (Matcher)IsIterableContaining.hasItem((Object)"'on-error-propagate' has 'type' '${error.type}' which is resolved with a property and may cause the artifact to have different behavior on different environments."));
    }

    protected List<ExtensionModel> getRequiredExtensions() {
        ExtensionModel heisenberg = this.loadExtension(HeisenbergExtension.class, Collections.emptySet());
        ArrayList<ExtensionModel> extensions = new ArrayList<ExtensionModel>();
        extensions.addAll(super.getRequiredExtensions());
        extensions.add(heisenberg);
        return extensions;
    }

    public boolean ignoreParamsWithProperties() {
        return true;
    }
}

