/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.test.integration.lifecycle;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.functional.junit4.AbstractConfigurationFailuresTestCase;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tests.api.TestComponentsExtension;
import org.mule.tests.api.pojos.LifecycleObject;

@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Lifecycle Phase Failure")
public class MuleContextLifecycleTestCase
extends AbstractConfigurationFailuresTestCase {
    private static final String EXPECTED_A_CONTEXT_START_EXCEPTION_EXCEPTION = "Expected a ContextStartException exception";

    @Test
    @Ignore(value="MULE-15693")
    public void failOnStartInvokesStopInOtherComponentsButNotInTheFailedOne() {
        this.testOnContextLifecycleFailure("lifecycle/component-failing-during-startup-config.xml", failOnStartLifecycleBean -> new PollingProber().check((Probe)new JUnitLambdaProbe(() -> {
            LifecycleObject lifecycleBean = failOnStartLifecycleBean.getOtherLifecycleObject();
            Assert.assertThat((Object)failOnStartLifecycleBean.getCalledPhases(), (Matcher)Matchers.hasSize((int)3));
            Assert.assertThat((Object)failOnStartLifecycleBean.getCalledPhases(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"setMuleContext", "initialise", "start"}));
            Assert.assertThat((Object)lifecycleBean.getCalledPhases(), (Matcher)Matchers.hasSize((int)5));
            Assert.assertThat((Object)lifecycleBean.getCalledPhases(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"setMuleContext", "initialise", "start", "stop", "dispose"}));
            return true;
        })));
    }

    @Test
    public void failOnInitialiseInvokesDisposeInOtherComponentsButNotInTheFailedOne() {
        this.testOnContextLifecycleFailure("lifecycle/component-failing-during-initialise-config.xml", failOnStartLifecycleBean -> {
            LifecycleObject lifecycleBean = failOnStartLifecycleBean.getOtherLifecycleObject();
            Assert.assertThat((Object)lifecycleBean.getCalledPhases(), (Matcher)Matchers.hasSize((int)3));
            Assert.assertThat((Object)lifecycleBean.getCalledPhases(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"setMuleContext", "initialise", "dispose"}));
            Assert.assertThat((Object)failOnStartLifecycleBean.getCalledPhases(), (Matcher)Matchers.hasSize((int)2));
            Assert.assertThat((Object)failOnStartLifecycleBean.getCalledPhases(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"setMuleContext", "initialise"}));
        });
    }

    private void testOnContextLifecycleFailure(String configFile, Consumer<LifecycleObject> failureLifecycleBeanConsumer) {
        try {
            this.loadConfiguration(configFile);
            Assert.fail((String)EXPECTED_A_CONTEXT_START_EXCEPTION_EXCEPTION);
        }
        catch (LifecycleException e) {
            LifecycleObject lifecycleBean = (LifecycleObject)e.getComponent();
            failureLifecycleBeanConsumer.accept(lifecycleBean);
        }
        catch (Exception e) {
            Assert.fail((String)String.format("Expected a %s exception but got:\n%s", LifecycleException.class.getName(), e));
        }
    }

    protected List<ExtensionModel> getRequiredExtensions() {
        ExtensionModel testComponents = this.loadExtension(TestComponentsExtension.class, Collections.emptySet());
        ArrayList<ExtensionModel> extensions = new ArrayList<ExtensionModel>();
        extensions.add(testComponents);
        return extensions;
    }
}

