/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsIterableContaining;
import org.junit.Test;
import org.mule.extension.http.internal.temporary.HttpConnector;
import org.mule.extension.socket.api.SocketsExtension;
import org.mule.functional.junit4.AbstractConfigurationWarningsBeforeDeploymentTestCase;
import org.mule.runtime.api.meta.model.ExtensionModel;

@Feature(value="Error Handling")
@Story(value="Mule DSL Validations")
public class ErrorHandlingConfigurationWarningsBeforeDeploymentTestCase
extends AbstractConfigurationWarningsBeforeDeploymentTestCase {
    @Test
    @Issue(value="W-11802232")
    public void raisesErrorPropertyErrorTypeNotAllowed() throws Exception {
        this.loadConfiguration("org/mule/test/integration/exceptions/raise-error-property-type-config.xml");
        MatcherAssert.assertThat((Object)this.getWarningMessages(), (Matcher)IsIterableContaining.hasItem((Object)"'raise-error' has 'type' '${error.type}' which is resolved with a property and may cause the artifact to have different behavior on different environments."));
    }

    @Test
    @Issue(value="W-11802232")
    public void propertyTargetErrorMappingsNotAllowed() throws Exception {
        this.loadConfiguration("org/mule/test/integration/exceptions/property-error-mapping-target-config.xml");
        MatcherAssert.assertThat((Object)this.getWarningMessages(), (Matcher)IsIterableContaining.hasItem((Object)"'request' has 'type' '${error.type}' which is resolved with a property and may cause the artifact to have different behavior on different environments."));
    }

    @Test
    @Issue(value="W-11802232")
    public void propertySourceErrorMappingsNotAllowed() throws Exception {
        this.loadConfiguration("org/mule/test/integration/exceptions/property-error-mapping-source-config.xml");
        MatcherAssert.assertThat((Object)this.getWarningMessages(), (Matcher)IsIterableContaining.hasItem((Object)"'request' has 'type' '${error.type}' which is resolved with a property and may cause the artifact to have different behavior on different environments."));
    }

    @Test
    @Issue(value="W-11802232")
    public void propertyOnErrorNotAllowed() throws Exception {
        this.loadConfiguration("org/mule/test/integration/exceptions/property-on-error-config.xml");
        MatcherAssert.assertThat((Object)this.getWarningMessages(), (Matcher)IsIterableContaining.hasItem((Object)"'on-error-propagate' has 'type' '${error.type}' which is resolved with a property and may cause the artifact to have different behavior on different environments."));
    }

    protected List<ExtensionModel> getRequiredExtensions() {
        ExtensionModel sockets = this.loadExtension(SocketsExtension.class, Collections.emptySet());
        ExtensionModel http = this.loadExtension(HttpConnector.class, Collections.singleton(sockets));
        ArrayList<ExtensionModel> extensions = new ArrayList<ExtensionModel>();
        extensions.addAll(super.getRequiredExtensions());
        extensions.add(http);
        extensions.add(sockets);
        return extensions;
    }
}

