/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config.spring.parsers;

import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsIterableContaining;
import org.junit.Assert;
import org.junit.Test;
import org.mule.extension.http.internal.temporary.HttpConnector;
import org.mule.extension.socket.api.SocketsExtension;
import org.mule.functional.junit4.AbstractConfigurationFailuresTestCase;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ArtifactType;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResult;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.dsl.api.ConfigResource;

@Story(value="Mule DSL Validations")
public class StereotypeConfigurationWarningsBeforeDeploymentTestCase
extends AbstractConfigurationFailuresTestCase {
    private List<String> warningMessages;

    @Test
    @Issue(value="W-11802232")
    public void failureOnInvalidImport() throws Exception {
        this.loadConfiguration("org/mule/config/spring/parsers/dsl-validation-stereotype-config.xml");
        MatcherAssert.assertThat(this.warningMessages, (Matcher)IsIterableContaining.hasItem((Object)"'http:listener' has 'config-ref' '${http.listener.name}' which is resolved with a property and may cause the artifact to have different behavior on different environments."));
    }

    private AstXmlParser getParser(Set<ExtensionModel> extensions) {
        AstXmlParser.Builder builder = AstXmlParser.builder().withExtensionModels(extensions).withArtifactType(ArtifactType.APPLICATION).withParentArtifact(MuleAstUtils.emptyArtifact());
        return builder.build();
    }

    protected void loadConfiguration(String configuration) throws MuleException, InterruptedException {
        ArtifactAst ast;
        try {
            ast = this.getParser(new HashSet<ExtensionModel>(this.getRequiredExtensions())).parse(new ConfigResource[]{new ConfigResource(configuration)});
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        ValidationResult validationResult = MuleAstUtils.validatorBuilder().ignoreParamsWithProperties(true).build().validate(ast);
        validationResult.getItems().stream().filter(vri -> vri.getValidation().getLevel().equals((Object)Validation.Level.ERROR)).forEach(vri -> Assert.fail((String)vri.getMessage()));
        this.warningMessages = validationResult.getItems().stream().filter(vri -> vri.getValidation().getLevel().equals((Object)Validation.Level.WARN)).map(v -> v.getMessage()).collect(Collectors.toList());
    }

    protected List<ExtensionModel> getRequiredExtensions() {
        ExtensionModel sockets = this.loadExtension(SocketsExtension.class, Collections.emptySet());
        ExtensionModel http = this.loadExtension(HttpConnector.class, Collections.singleton(sockets));
        ArrayList<ExtensionModel> extensions = new ArrayList<ExtensionModel>();
        extensions.addAll(super.getRequiredExtensions());
        extensions.add(http);
        extensions.add(sockets);
        return extensions;
    }
}

