/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config.spring.parsers;

import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsIterableContaining;
import org.junit.Assert;
import org.junit.Test;
import org.mule.extension.http.internal.temporary.HttpConnector;
import org.mule.extension.socket.api.SocketsExtension;
import org.mule.functional.junit4.AbstractConfigurationWarningsBeforeDeploymentTestCase;
import org.mule.runtime.api.meta.model.ExtensionModel;

@Story(value="Mule DSL Validations")
public class StereotypeConfigurationWarningsBeforeDeploymentTestCase
extends AbstractConfigurationWarningsBeforeDeploymentTestCase {
    @Test
    @Issue(value="W-11802232")
    public void failureOnInvalidImport() throws Exception {
        this.loadConfiguration("org/mule/config/spring/parsers/dsl-validation-stereotype-config.xml");
        Assert.assertThat((Object)this.getWarningMessages(), (Matcher)IsIterableContaining.hasItem((Object)"'http:listener' has 'config-ref' '${http.listener.name}' which is resolved with a property and may cause the artifact to have different behavior on different environments."));
    }

    protected List<ExtensionModel> getRequiredExtensions() {
        ExtensionModel sockets = this.loadExtension(SocketsExtension.class, Collections.emptySet());
        ExtensionModel http = this.loadExtension(HttpConnector.class, Collections.singleton(sockets));
        ArrayList<ExtensionModel> extensions = new ArrayList<ExtensionModel>();
        extensions.addAll(super.getRequiredExtensions());
        extensions.add(http);
        extensions.add(sockets);
        return extensions;
    }
}

