/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.functional.junit4.AbstractConfigurationFailuresTestCase;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;

@Feature(value="Error Handling")
@Story(value="Mule DSL Validations")
@RunWith(value=Parameterized.class)
public class ErrorHandlingConfigurationFailuresWaivesTestCase
extends AbstractConfigurationFailuresTestCase {
    public MuleVersion minMuleVersion;
    @Rule
    public ExpectedException expectedException;

    @Parameterized.Parameters(name="version: {0}")
    public static Collection<Object[]> featureFlags() {
        ExpectedException expected = ExpectedException.none();
        expected.expect(ConfigurationException.class);
        expected.expectMessage(Matchers.containsString((String)ErrorHandlingConfigurationFailuresWaivesTestCase.notFound("APP:NONEXISTENT")));
        return Arrays.asList({"4.5.0", expected}, {"4.4.0", ExpectedException.none()});
    }

    public ErrorHandlingConfigurationFailuresWaivesTestCase(String minMuleVersion, ExpectedException expectedException) {
        this.minMuleVersion = new MuleVersion(minMuleVersion);
        this.expectedException = expectedException;
    }

    @Test
    @Issue(value="MULE-19879")
    public void unknownErrorFilteringNotAllowed() throws Exception {
        this.loadConfiguration("org/mule/test/integration/exceptions/global-unreferenced-invalid-error-handler.xml");
    }

    protected void applyConfiguration(DefaultMuleConfiguration muleConfiguration) {
        super.applyConfiguration(muleConfiguration);
        muleConfiguration.setMinMuleVersion(this.minMuleVersion);
    }

    private static String notFound(String type) {
        return String.format("Could not find error '%s'", type);
    }
}

