/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.module.launcher.application.Application;
import org.mule.rule.UseMuleLog4jContextFactory;
import org.mule.test.infrastructure.deployment.AbstractFakeMuleServerTestCase;

public class LogConfigurationTestCase
extends AbstractFakeMuleServerTestCase {
    public static final String APP_NAME = "app1";
    public static final String DOMAIN_NAME = "domain";
    @Rule
    public UseMuleLog4jContextFactory muleLogging = new UseMuleLog4jContextFactory();

    public void setUp() throws Exception {
        super.setUp();
        System.clearProperty("mule.simpleLog");
    }

    @Test
    public void defaultAppLoggingConfigurationOnlyLogsOnApplicationLogFile() throws Exception {
        this.muleServer.start();
        this.muleServer.deploy("/log/emptyApp.zip", APP_NAME);
        this.ensureOnlyDefaultAppender();
    }

    @Test
    public void defaultAppInDomainLoggingConfigurationOnlyLogsOnApplicationLogFile() throws Exception {
        this.muleServer.start();
        this.muleServer.deployDomainFromClasspathFolder("log/empty-domain", DOMAIN_NAME);
        this.muleServer.deploy("/log/appInDomain.zip", APP_NAME);
        this.ensureOnlyDefaultAppender();
    }

    @Test
    public void honorLog4jConfigFileForApp() throws Exception {
        this.muleServer.start();
        this.muleServer.deploy("/log/appWithLog4j.zip", APP_NAME);
        this.ensureArtifactAppender("consoleForApp", ConsoleAppender.class);
    }

    @Test
    public void honorLog4jConfigFileForAppInDomain() throws Exception {
        this.muleServer.start();
        this.muleServer.deployDomainFromClasspathFolder("log/empty-domain-with-log4j", DOMAIN_NAME);
        this.muleServer.deploy("/log/appInDomain.zip", APP_NAME);
        this.ensureArtifactAppender("ConsoleForDomain", ConsoleAppender.class);
    }

    private void ensureOnlyDefaultAppender() throws Exception {
        Assert.assertThat((Object)1, (Matcher)CoreMatchers.equalTo((Object)this.appendersCount(APP_NAME)));
        Assert.assertThat((Object)1, (Matcher)CoreMatchers.equalTo((Object)this.selectByClass(APP_NAME, RollingFileAppender.class).size()));
        RollingFileAppender fileAppender = (RollingFileAppender)this.selectByClass(APP_NAME, RollingFileAppender.class).get(0);
        Assert.assertThat((Object)"defaultFileAppender", (Matcher)CoreMatchers.equalTo((Object)fileAppender.getName()));
        Assert.assertThat((Object)fileAppender.getFileName(), (Matcher)CoreMatchers.containsString((String)String.format("mule-app-%s.log", APP_NAME)));
    }

    private void ensureArtifactAppender(final String appenderName, final Class<? extends Appender> appenderClass) throws Exception {
        this.withAppClassLoader(APP_NAME, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Logger logger = LogConfigurationTestCase.this.getRootLoggerForApp(LogConfigurationTestCase.APP_NAME);
                Assert.assertThat((Object)Level.WARN, (Matcher)CoreMatchers.equalTo((Object)logger.getLevel()));
                Assert.assertThat((Object)true, (Matcher)CoreMatchers.equalTo((Object)LogConfigurationTestCase.this.loggerHasAppender(LogConfigurationTestCase.APP_NAME, logger, appenderName)));
                Assert.assertThat((Object)1, (Matcher)CoreMatchers.equalTo((Object)LogConfigurationTestCase.this.appendersCount(LogConfigurationTestCase.APP_NAME)));
                Assert.assertThat((Object)1, (Matcher)CoreMatchers.equalTo((Object)LogConfigurationTestCase.this.selectByClass(LogConfigurationTestCase.APP_NAME, appenderClass).size()));
                Assert.assertThat((Object)appenderName, (Matcher)CoreMatchers.equalTo((Object)((Appender)LogConfigurationTestCase.this.selectByClass(LogConfigurationTestCase.APP_NAME, appenderClass).get(0)).getName()));
                return null;
            }
        });
    }

    private boolean loggerHasAppender(String appName, Logger logger, String appenderName) throws Exception {
        return this.getContext(appName).getConfiguration().getLoggerConfig(logger.getName()).getAppenders().containsKey(appenderName);
    }

    private Logger getRootLoggerForApp(String appName) throws Exception {
        return this.getContext(appName).getLogger("");
    }

    private LoggerContext getContext(final String appName) throws Exception {
        return this.withAppClassLoader(appName, new Callable<LoggerContext>(){

            @Override
            public LoggerContext call() throws Exception {
                Application app = LogConfigurationTestCase.this.muleServer.findApplication(appName);
                ClassLoader classLoader = app.getMuleContext().getExecutionClassLoader();
                return (LoggerContext)LogManager.getContext((ClassLoader)classLoader, (boolean)false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withAppClassLoader(String appName, Callable<T> closure) throws Exception {
        Application app = this.muleServer.findApplication(appName);
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = app.getMuleContext().getExecutionClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            T t = closure.call();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    private List<Appender> selectByClass(String appName, Class<?> appenderClass) throws Exception {
        LoggerContext context = this.getContext(appName);
        LinkedList<Appender> filteredAppenders = new LinkedList<Appender>();
        for (Appender appender : context.getConfiguration().getAppenders().values()) {
            if (!appenderClass.isAssignableFrom(appender.getClass())) continue;
            filteredAppenders.add(appender);
        }
        return filteredAppenders;
    }

    private int appendersCount(String appName) throws Exception {
        return this.selectByClass(appName, Appender.class).size();
    }
}

