/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.MessageExchangePattern;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.tck.functional.FlowAssert;
import org.mule.tck.junit4.FunctionalTestCase;

public class NonBlockingFullySupportedFunctionalTestCase
extends FunctionalTestCase {
    public static String FOO = "foo";

    protected String getConfigFile() {
        return "non-blocking-fully-supported-test-config.xml";
    }

    @Test
    public void flow() throws Exception {
        this.testFlowNonBlocking("flow", this.getMessageExchnagePattern());
    }

    @Test
    public void subFlow() throws Exception {
        this.testFlowNonBlocking("subFlow", this.getMessageExchnagePattern());
    }

    @Test
    public void childFlow() throws Exception {
        this.testFlowNonBlocking("childFlow", this.getMessageExchnagePattern());
        FlowAssert.verify((String)"childFlowChild");
    }

    @Test
    public void childDefaultFlow() throws Exception {
        this.testFlowNonBlocking("childDefaultFlow", this.getMessageExchnagePattern());
        FlowAssert.verify((String)"childDefaultFlowChild");
    }

    @Test
    public void childSyncFlow() throws Exception {
        this.testFlowNonBlocking("childSyncFlow", this.getMessageExchnagePattern());
        FlowAssert.verify((String)"childSyncFlowChild");
    }

    @Test(expected=MessagingException.class)
    public void childAsyncFlow() throws Exception {
        this.testFlowNonBlocking("childAsyncFlow", this.getMessageExchnagePattern());
        FlowAssert.verify((String)"childAsyncFlowChild");
    }

    @Test(expected=MessagingException.class)
    public void childQueuedAsyncFlow() throws Exception {
        this.testFlowNonBlocking("childQueuedAsyncFlow", this.getMessageExchnagePattern());
        FlowAssert.verify((String)"childQueuedAsyncFlowChild");
    }

    @Test
    public void processorChain() throws Exception {
        this.testFlowNonBlocking("processorChain", this.getMessageExchnagePattern());
    }

    @Test
    public void filterAccepts() throws Exception {
        this.testFlowNonBlocking("filterAccepts", this.getMessageExchnagePattern());
    }

    @Test
    public void filterRejects() throws Exception {
        MuleEvent result = this.runFlowNonBlocking("filterRejects", this.getMessageExchnagePattern());
        FlowAssert.verify((String)"filterRejects");
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void filterAfterNonBlockingAccepts() throws Exception {
        this.testFlowNonBlocking("filterAfterNonBlockingAccepts", this.getMessageExchnagePattern());
    }

    @Test
    public void filterAfterNonBlockingRejects() throws Exception {
        MuleEvent result = this.runFlowNonBlocking("filterAfterNonBlockingRejects", this.getMessageExchnagePattern());
        FlowAssert.verify((String)"filterAfterNonBlockingRejects");
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void filterBeforeNonBlockingAccepts() throws Exception {
        this.testFlowNonBlocking("filterAfterNonBlockingAccepts", this.getMessageExchnagePattern());
    }

    @Test
    public void filterBeforeNonBlockingRejects() throws Exception {
        MuleEvent result = this.runFlowNonBlocking("filterAfterNonBlockingRejects", this.getMessageExchnagePattern());
        FlowAssert.verify((String)"filterAfterNonBlockingRejects");
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void filterAfterEnricherBeforeNonBlocking() throws Exception {
        MuleEvent result = this.runFlowNonBlocking("filterAfterEnricherBeforeNonBlocking", this.getMessageExchnagePattern());
        FlowAssert.verify((String)"filterAfterEnricherBeforeNonBlocking");
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void securityFilter() throws Exception {
        this.testFlowNonBlocking("security-filter", this.getMessageExchnagePattern());
    }

    @Test
    public void transformer() throws Exception {
        this.testFlowNonBlocking("transformer", this.getMessageExchnagePattern());
    }

    @Test
    public void choice() throws Exception {
        this.testFlowNonBlocking("choice", this.getMessageExchnagePattern());
    }

    @Test
    public void enricher() throws Exception {
        this.testFlowNonBlocking("enricher", this.getMessageExchnagePattern());
    }

    @Test
    public void response() throws Exception {
        this.testFlowNonBlocking("response", this.getMessageExchnagePattern());
    }

    @Test
    public void responseWithNullEvent() throws Exception {
        MuleEvent result = this.runFlowNonBlocking("responseWithNullEvent", this.getMessageExchnagePattern());
        FlowAssert.verify((String)"responseWithNullEvent");
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void enricherIssue() throws Exception {
        MuleEvent result = this.runFlowNonBlocking("enricherIssue", this.getMessageExchnagePattern());
        FlowAssert.verify((String)"enricherIssue");
        Assert.assertThat((Object)result.getMessageAsString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"Test Message")));
    }

    @Test
    public void enricherIssueNonBlocking() throws Exception {
        MuleEvent result = this.runFlowNonBlocking("enricherIssueNonBlocking", this.getMessageExchnagePattern());
        FlowAssert.verify((String)"enricherIssueNonBlocking");
        Assert.assertThat((Object)result.getMessageAsString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"Test Message")));
    }

    @Test
    public void enricherFlowVar() throws Exception {
        MuleEvent result = this.runFlowNonBlocking("enricherFlowVar", this.getMessageExchnagePattern());
        FlowAssert.verify((String)"enricherFlowVar");
        Assert.assertThat((Object)((String)result.getFlowVariable(FOO)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"Test Message")));
    }

    @Test
    public void testTransportOutboundEndpoint() throws Exception {
        MuleEvent result = this.runFlowNonBlocking("testOutboundEndpoint", this.getMessageExchnagePattern());
        FlowAssert.verify((String)"testOutboundEndpoint");
        Assert.assertThat((Object)result.getMessageAsString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"Test Message")));
    }

    @Test
    public void testTransportOutboundEndpointError() throws Exception {
        MuleEvent result = this.runFlowNonBlocking("testOutboundEndpointError", this.getMessageExchnagePattern());
        FlowAssert.verify((String)"testOutboundEndpointError");
        Assert.assertThat((Object)result.getMessageAsString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"Test Message")));
    }

    @Test
    public void async() throws Exception {
        this.testFlowNonBlocking("async");
    }

    @Test
    public void catchExceptionStrategy() throws Exception {
        this.testFlowNonBlocking("catchExceptionStrategy", this.getMessageExchnagePattern());
        FlowAssert.verify((String)"catchExceptionStrategyChild");
    }

    @Test
    public void asyncThrowsErrorInsideErrorHandler() throws Exception {
        this.testFlowNonBlocking("asyncThrowsErrorInsideErrorHandler", this.getMessageExchnagePattern());
    }

    protected MessageExchangePattern getMessageExchnagePattern() {
        return MessageExchangePattern.REQUEST_RESPONSE;
    }
}

