/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.component.ComponentException;
import org.mule.construct.Flow;
import org.mule.tck.exceptions.FunctionalTestException;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FlowAssert;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.concurrent.Latch;

public class NonBlockingNotSupportedFunctionalTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "non-blocking-not-supported-test-config.xml";
    }

    @Test
    public void syncFlow() throws Exception {
        this.testFlowNonBlocking("syncFlow");
    }

    @Test
    public void splitter() throws Exception {
        this.testFlowNonBlocking("splitter", NonBlockingNotSupportedFunctionalTestCase.getTestEventUsingFlow((Object)new String[]{"1", "2", "3"}));
    }

    @Test
    public void untilSuccessful() throws Exception {
        this.testFlowNonBlocking("untilSuccessful");
    }

    @Test
    public void scatterGather() throws Exception {
        this.testFlowNonBlocking("scatterGather");
    }

    @Test
    public void all() throws Exception {
        this.testFlowNonBlocking("all");
    }

    @Test
    public void firstSuccessful() throws Exception {
        this.testFlowNonBlocking("firstSuccessful");
    }

    @Test
    public void roundRobin() throws Exception {
        this.testFlowNonBlocking("roundRobin");
    }

    @Test
    public void requestReply() throws Exception {
        this.testFlowNonBlocking("requestReply");
    }

    @Test
    public void aggregator() throws Exception {
        Flow flow = this.lookupFlowConstruct("aggregator");
        String correlationId = "id";
        int correlationGroupSize = 3;
        DefaultMuleMessage message1 = new DefaultMuleMessage((Object)"Test Message", muleContext);
        message1.setCorrelationId(correlationId);
        message1.setCorrelationGroupSize(correlationGroupSize);
        message1.setCorrelationSequence(1);
        this.runFlowNonBlocking("aggregator", (MuleEvent)new DefaultMuleEvent((MuleMessage)message1, MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)flow));
        DefaultMuleMessage message2 = new DefaultMuleMessage((Object)"Test Message", muleContext);
        message2.setCorrelationId(correlationId);
        message2.setCorrelationGroupSize(correlationGroupSize);
        message2.setCorrelationSequence(2);
        message2.setMessageRootId(message1.getMessageRootId());
        this.runFlowNonBlocking("aggregator", (MuleEvent)new DefaultMuleEvent((MuleMessage)message2, MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)flow));
        DefaultMuleMessage message3 = new DefaultMuleMessage((Object)"Test Message", muleContext);
        message3.setCorrelationId(correlationId);
        message3.setCorrelationGroupSize(correlationGroupSize);
        message3.setCorrelationSequence(3);
        message3.setMessageRootId(message1.getMessageRootId());
        this.runFlowNonBlocking("aggregator", (MuleEvent)new DefaultMuleEvent((MuleMessage)message3, MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)flow));
        FlowAssert.verify((String)"aggregator");
    }

    @Test
    public void poll() throws Exception {
        final Latch latch = new Latch();
        ((FunctionalTestComponent)this.getComponent("poll")).setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                latch.countDown();
            }
        });
        latch.await(5000L, TimeUnit.MILLISECONDS);
        FlowAssert.verify((String)"poll");
    }

    @Test
    public void transactional() throws Exception {
        this.testFlowNonBlocking("transactional");
    }

    @Test
    public void rollbackRollbackExceptionStrategy() throws Exception {
        try {
            this.runFlowNonBlocking("rollbackRollbackExceptionStrategy");
            Assert.fail((String)"Exception Expected");
        }
        catch (ComponentException componentException) {
            Assert.assertThat((Object)componentException.getCause(), (Matcher)CoreMatchers.instanceOf(FunctionalTestException.class));
        }
        finally {
            FlowAssert.verify((String)"rollbackRollbackExceptionStrategy");
            FlowAssert.verify((String)"rollbackExceptionStrategyChild");
        }
    }

    @Test
    public void catchRollbackExceptionStrategy() throws Exception {
        this.testFlowNonBlocking("catchRollbackExceptionStrategy");
        FlowAssert.verify((String)"rollbackExceptionStrategyChild");
    }
}

