/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.annotations.param;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.annotations.param.DataHandlerTransformer;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.expression.RequiredValueException;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.ExceptionUtils;
import org.mule.util.StringDataSource;

public class InboundAttachmentsAnnotationTestCase
extends AbstractServiceAndFlowTestCase {
    private MuleMessage muleMessage;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/annotations/inbound-attachments-annotation-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/annotations/inbound-attachments-annotation-flow.xml"});
    }

    public InboundAttachmentsAnnotationTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        this.setDisposeContextPerClass(true);
    }

    public void doSetUp() throws Exception {
        super.doSetUp();
        this.muleMessage = this.createMessage(null, null);
        muleContext.getRegistry().registerObject("dataHandlerTransformers", (Object)new DataHandlerTransformer());
    }

    protected MuleMessage createMessage(Map<String, Object> headers, Map<String, DataHandler> attachments) throws Exception {
        if (headers == null) {
            headers = new HashMap<String, Object>();
            headers.put("foo", "fooValue");
            headers.put("bar", "barValue");
            headers.put("baz", "bazValue");
        }
        if (attachments == null) {
            attachments = new HashMap<String, DataHandler>();
            attachments.put("foo", new DataHandler((DataSource)new StringDataSource("fooValue")));
            attachments.put("bar", new DataHandler((DataSource)new StringDataSource("barValue")));
            attachments.put("baz", new DataHandler((DataSource)new StringDataSource("bazValue")));
        }
        MuleMessage message = this.getTestMuleMessage();
        for (Map.Entry<String, DataHandler> attachment : attachments.entrySet()) {
            message.addOutboundAttachment(attachment.getKey(), attachment.getValue());
        }
        for (String s : headers.keySet()) {
            message.setOutboundProperty(s, headers.get(s));
        }
        return message;
    }

    @Test
    public void testSingleAttachment() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://attachment", this.muleMessage);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((boolean)(message.getPayload() instanceof DataHandler));
        Assert.assertEquals((Object)"fooValue", (Object)((DataHandler)message.getPayload()).getContent());
    }

    @Test
    public void testSingleAttachmentWithType() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://attachmentWithType", this.muleMessage);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((boolean)(message.getPayload() instanceof String));
        Assert.assertEquals((Object)"fooValue", (Object)message.getPayload());
    }

    @Test
    public void testSingleAttachmentOptional() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://attachmentOptional", this.muleMessage);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertEquals((Object)"faz not set", (Object)message.getPayload());
    }

    @Test
    public void testSingleAttachmentWithTypeNoMatchingTransform() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://attachmentWithType", this.muleMessage);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((boolean)(message.getPayload() instanceof String));
        Assert.assertEquals((Object)"fooValue", (Object)message.getPayload());
    }

    @Test
    public void testMapAttachments() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://attachments", this.muleMessage);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a Map", (boolean)(message.getPayload() instanceof Map));
        Map<String, DataHandler> result = this.getMapPayload(message);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)"fooValue", (Object)result.get("foo").getContent());
        Assert.assertEquals((Object)"barValue", (Object)result.get("bar").getContent());
        Assert.assertNull((Object)result.get("baz"));
    }

    @Test
    public void testMapAttachmentsMissing() throws Exception {
        this.muleMessage = this.createMessage(null, new HashMap<String, DataHandler>());
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://attachments", this.muleMessage);
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getExceptionPayload());
        Assert.assertEquals(RequiredValueException.class, ExceptionUtils.getRootCause((Throwable)message.getExceptionPayload().getException()).getClass());
    }

    @Test
    public void testMapSingleAttachment() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://singleAttachmentMap", this.muleMessage);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a Map", (boolean)(message.getPayload() instanceof Map));
        Map<String, DataHandler> result = this.getMapPayload(message);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"fooValue", (Object)result.get("foo").getContent());
        Assert.assertNull((Object)result.get("bar"));
        Assert.assertNull((Object)result.get("baz"));
    }

    @Test
    public void testMapAttachmentsOptional() throws Exception {
        HashMap<String, DataHandler> attachments = new HashMap<String, DataHandler>();
        attachments.put("foo", new DataHandler((DataSource)new StringDataSource("fooValue")));
        attachments.put("bar", new DataHandler((DataSource)new StringDataSource("barValue")));
        this.muleMessage = this.createMessage(null, attachments);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://attachmentsOptional", this.muleMessage);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a Map", (boolean)(message.getPayload() instanceof Map));
        Map<String, DataHandler> result = this.getMapPayload(message);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)"fooValue", (Object)result.get("foo").getContent());
        Assert.assertEquals((Object)"barValue", (Object)result.get("bar").getContent());
        Assert.assertNull((Object)result.get("baz"));
    }

    @Test
    public void testMapAttachmentsAllOptional() throws Exception {
        this.muleMessage = this.createMessage(null, new HashMap<String, DataHandler>());
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://attachmentsAllOptional", this.muleMessage);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a Map", (boolean)(message.getPayload() instanceof Map));
        Map result = (Map)message.getPayload();
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testMapAttachmentsUnmodifiable() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://attachmentsUnmodifiable", this.muleMessage);
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getExceptionPayload());
        Assert.assertEquals(UnsupportedOperationException.class, ExceptionUtils.getRootCause((Throwable)message.getExceptionPayload().getException()).getClass());
    }

    @Test
    public void testMapAttachmentsAll() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://attachmentsAll", this.muleMessage);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a Map", (boolean)(message.getPayload() instanceof Map));
        Map<String, DataHandler> result = this.getMapPayload(message);
        Assert.assertTrue((result.size() >= 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"fooValue", (Object)result.get("foo").getContent());
        Assert.assertEquals((Object)"barValue", (Object)result.get("bar").getContent());
        Assert.assertEquals((Object)"bazValue", (Object)result.get("baz").getContent());
    }

    @Test
    public void testMapAttachmentsWildcard() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://attachmentsWildcard", this.muleMessage);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a Map", (boolean)(message.getPayload() instanceof Map));
        Map result = (Map)message.getPayload(DataTypeFactory.create(Map.class));
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertNull(result.get("foo"));
        Assert.assertNotNull(result.get("bar"));
        Assert.assertNotNull(result.get("baz"));
    }

    @Test
    public void testMapAttachmentsMultiWildcard() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://attachmentsMultiWildcard", this.muleMessage);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a Map", (boolean)(message.getPayload() instanceof Map));
        Map result = (Map)message.getPayload();
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertNotNull(result.get("foo"));
        Assert.assertNotNull(result.get("bar"));
        Assert.assertNotNull(result.get("baz"));
    }

    @Test
    public void testListAttachments() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://attachmentsList", this.muleMessage);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a List", (boolean)(message.getPayload() instanceof List));
        List result = (List)message.getPayload();
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertTrue((boolean)result.contains("fooValue"));
        Assert.assertTrue((boolean)result.contains("barValue"));
        Assert.assertTrue((boolean)result.contains("bazValue"));
    }

    @Test
    public void testListAttachmentsWithOptional() throws Exception {
        HashMap<String, DataHandler> attachments = new HashMap<String, DataHandler>();
        attachments.put("foo", new DataHandler((DataSource)new StringDataSource("fooValue")));
        attachments.put("bar", new DataHandler((DataSource)new StringDataSource("barValue")));
        this.muleMessage = this.createMessage(null, attachments);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://attachmentsListOptional", this.muleMessage);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a List", (boolean)(message.getPayload() instanceof List));
        List result = (List)message.getPayload();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)result.contains("fooValue"));
        Assert.assertTrue((boolean)result.contains("barValue"));
    }

    @Test
    public void testListAttachmentsWithAllOptional() throws Exception {
        this.muleMessage = this.createMessage(null, new HashMap<String, DataHandler>());
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://attachmentsListAllOptional", this.muleMessage);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a List", (boolean)(message.getPayload() instanceof List));
        List result = (List)message.getPayload();
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testListAttachmentsWithMissing() throws Exception {
        HashMap<String, DataHandler> attachments = new HashMap<String, DataHandler>();
        attachments.put("foo", new DataHandler((DataSource)new StringDataSource("fooValue")));
        attachments.put("baz", new DataHandler((DataSource)new StringDataSource("bazValue")));
        this.muleMessage = this.createMessage(null, attachments);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("vm://attachmentsListOptional", this.muleMessage);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getExceptionPayload());
        Assert.assertEquals(RequiredValueException.class, ExceptionUtils.getRootCause((Throwable)result.getExceptionPayload().getException()).getClass());
    }

    @Test
    public void testSingleListAttachment() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://singleAttachmentList", this.muleMessage);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a List", (boolean)(message.getPayload() instanceof List));
        List result = (List)message.getPayload();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.contains("fooValue"));
    }

    @Test
    public void testListAttachmentsUnmodifiable() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("vm://attachmentsListUnmodifiable", this.muleMessage);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getExceptionPayload());
        Assert.assertEquals(UnsupportedOperationException.class, ExceptionUtils.getRootCause((Throwable)result.getExceptionPayload().getException()).getClass());
    }

    @Test
    public void testListAttachmentsAll() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://attachmentsListAll", this.muleMessage);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a List", (boolean)(message.getPayload() instanceof List));
        List result = (List)message.getPayload();
        Assert.assertTrue((result.size() >= 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)result.contains("fooValue"));
        Assert.assertTrue((boolean)result.contains("barValue"));
        Assert.assertTrue((boolean)result.contains("bazValue"));
    }

    @Test
    public void testListAttachmentsWilcard() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://attachmentsListWildcard", this.muleMessage);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a List", (boolean)(message.getPayload() instanceof List));
        List result = (List)message.getPayload();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertFalse((boolean)result.contains("fooValue"));
        Assert.assertTrue((boolean)result.contains("barValue"));
        Assert.assertTrue((boolean)result.contains("bazValue"));
    }

    @Test
    public void testListAttachmentsMultiWilcard() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://attachmentsListMultiWildcard", this.muleMessage);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a List", (boolean)(message.getPayload() instanceof List));
        List result = (List)message.getPayload();
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertTrue((boolean)result.contains("fooValue"));
        Assert.assertTrue((boolean)result.contains("barValue"));
        Assert.assertTrue((boolean)result.contains("bazValue"));
    }

    private Map<String, DataHandler> getMapPayload(MuleMessage message) {
        return (Map)message.getPayload();
    }
}

