/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.processor.MessageProcessor;
import org.mule.construct.Flow;
import org.mule.routing.IdempotentMessageFilter;
import org.mule.routing.IdempotentSecureHashMessageFilter;
import org.mule.routing.MessageFilter;
import org.mule.routing.filters.WildcardFilter;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transformer.simple.CombineCollectionsTransformer;

public class GlobalInterceptingMessageProcessorsTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "global-intercepting-mps-config.xml";
    }

    @Test
    public void testConfig() throws Exception {
        Flow flow1 = (Flow)muleContext.getRegistry().lookupObject("flow1");
        Assert.assertNotNull((Object)flow1);
        List mpList = flow1.getMessageProcessors();
        MessageProcessor mp1 = (MessageProcessor)muleContext.getRegistry().lookupObject("idempotentFilter");
        Assert.assertTrue((boolean)(mp1 instanceof IdempotentMessageFilter));
        IdempotentMessageFilter imf = (IdempotentMessageFilter)mp1;
        Assert.assertEquals((Object)imf.getIdExpression(), (Object)"#[payload:]");
        this.assertMpPresent(mpList, mp1, IdempotentMessageFilter.class);
        MessageProcessor mp2 = (MessageProcessor)muleContext.getRegistry().lookupObject("messageFilter");
        Assert.assertTrue((boolean)(mp2 instanceof MessageFilter));
        MessageFilter mf = (MessageFilter)mp2;
        Assert.assertTrue((boolean)(mf.getFilter() instanceof WildcardFilter));
        Assert.assertFalse((boolean)mf.isThrowOnUnaccepted());
        this.assertMpPresent(mpList, mp2, MessageFilter.class);
        MessageProcessor mp3 = (MessageProcessor)muleContext.getRegistry().lookupObject("idempotentSecureHashMessageFilter");
        Assert.assertTrue((boolean)(mp3 instanceof IdempotentSecureHashMessageFilter));
        IdempotentSecureHashMessageFilter ishmf = (IdempotentSecureHashMessageFilter)mp3;
        Assert.assertEquals((Object)ishmf.getMessageDigestAlgorithm(), (Object)"MDA5");
        this.assertMpPresent(mpList, mp3, IdempotentSecureHashMessageFilter.class);
        MessageProcessor mp4 = (MessageProcessor)muleContext.getRegistry().lookupObject("combineCollectionsTransformer");
        Assert.assertTrue((boolean)(mp4 instanceof CombineCollectionsTransformer));
        this.assertMpPresent(mpList, mp4, CombineCollectionsTransformer.class);
    }

    private void assertMpPresent(List<MessageProcessor> mpList, MessageProcessor mp, Class<?> clazz) {
        Assert.assertFalse((boolean)mpList.contains(mp));
        for (MessageProcessor theMp : mpList) {
            if (!clazz.isInstance(theMp)) continue;
            return;
        }
        Assert.fail((String)("No " + clazz.getSimpleName() + " found"));
    }
}

