/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.config.spring.TestLifecycleObject;
import org.mule.tck.junit4.FunctionalTestCase;

public class LookupPrototypeByKeyTestCase
extends FunctionalTestCase {
    private static final String PROTOTYPE_KEY = "prototype";

    protected String getConfigFile() {
        return "prototype-lifecycle-object-config.xml";
    }

    @Test
    public void lookupWithLifecycle() throws Exception {
        TestLifecycleObject object = (TestLifecycleObject)muleContext.getRegistry().lookupObject(PROTOTYPE_KEY, true);
        this.assertLifecycleApplied(object);
    }

    @Test
    public void lookupWithoutLifecycle() throws Exception {
        TestLifecycleObject object = (TestLifecycleObject)muleContext.getRegistry().lookupObject(PROTOTYPE_KEY, false);
        this.assertLifecycleNotApplied(object);
    }

    @Test
    public void defaultLookupPrototype() throws Exception {
        TestLifecycleObject object = (TestLifecycleObject)muleContext.getRegistry().lookupObject(PROTOTYPE_KEY);
        this.assertLifecycleApplied(object);
    }

    private void assertLifecycleApplied(TestLifecycleObject object) {
        Assert.assertThat((Object)object.getInitialise(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)object.getStart(), (Matcher)CoreMatchers.is((Object)1));
    }

    private void assertLifecycleNotApplied(TestLifecycleObject object) {
        Assert.assertThat((Object)object.getInitialise(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)object.getStart(), (Matcher)CoreMatchers.is((Object)0));
    }
}

