/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.context.notification.FlowCallStack;
import org.mule.api.context.notification.MessageProcessorNotificationListener;
import org.mule.context.notification.MessageProcessorNotification;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.util.FlowTraceUtils;

public class FlowStackTestCase
extends FunctionalTestCase {
    @Rule
    public SystemProperty flowTraceEnabled = new SystemProperty("mule.flowTrace", "true");

    protected String getConfigFile() {
        return "org/mule/test/integration/notifications/flow-stack-config.xml";
    }

    @Before
    public void before() {
        muleContext.getNotificationManager().addInterfaceToType(MessageProcessorNotificationListener.class, MessageProcessorNotification.class);
        FlowTraceUtils.FlowStackAsserter.stackToAssert = null;
        FlowTraceUtils.FlowStackAsyncAsserter.latch = new CountDownLatch(1);
    }

    @Test
    public void flowStatic() throws Exception {
        muleContext.getClient().send("vm://in-flowStatic", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"/flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowStatic", (String)"/flowStatic/processors/0")});
    }

    @Test
    public void subFlowStatic() throws Exception {
        muleContext.getClient().send("vm://in-subFlowStatic", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"/subFlowStatic/processors/0/subFlow/subprocessors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowStatic", (String)"/subFlowStatic/processors/0")});
    }

    @Test
    public void flowDynamic() throws Exception {
        muleContext.getClient().send("vm://in-flowDynamic", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"/flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowDynamic", (String)"/flowDynamic/processors/0")});
    }

    @Test
    public void subFlowDynamic() throws Exception {
        muleContext.getClient().send("vm://in-subFlowDynamic", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"/subFlowDynamic/processors/0/subFlow/subprocessors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowDynamic", (String)"/subFlowDynamic/processors/0")});
    }

    @Test
    public void secondFlowStatic() throws Exception {
        muleContext.getClient().send("vm://in-secondFlowStatic", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"/flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"secondFlowStatic", (String)"/secondFlowStatic/processors/1")});
    }

    @Test
    public void secondSubFlowStatic() throws Exception {
        muleContext.getClient().send("vm://in-secondSubFlowStatic", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"/secondSubFlowStatic/processors/1/subFlow/subprocessors/0"), FlowTraceUtils.isFlowStackElement((String)"secondSubFlowStatic", (String)"/secondSubFlowStatic/processors/1")});
    }

    @Test
    public void secondFlowDynamic() throws Exception {
        muleContext.getClient().send("vm://in-secondFlowDynamic", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"/flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"secondFlowDynamic", (String)"/secondFlowDynamic/processors/1")});
    }

    @Test
    public void secondSubFlowDynamic() throws Exception {
        muleContext.getClient().send("vm://in-secondSubFlowDynamic", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"/secondSubFlowDynamic/processors/1/subFlow/subprocessors/0"), FlowTraceUtils.isFlowStackElement((String)"secondSubFlowDynamic", (String)"/secondSubFlowDynamic/processors/1")});
    }

    @Test
    public void recursiveSubFlowDynamic() throws Exception {
        muleContext.getClient().send("vm://in-recursiveSubFlowDynamic", (MuleMessage)new DefaultMuleMessage((Object)3, muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"/recursiveSubFlowDynamic/processors/0/recursiveSubFlow/subprocessors/1/recursiveSubFlow/subprocessors/1/recursiveSubFlow/subprocessors/1/subFlow/subprocessors/0"), FlowTraceUtils.isFlowStackElement((String)"recursiveSubFlow", (String)"/recursiveSubFlowDynamic/processors/0/recursiveSubFlow/subprocessors/1/recursiveSubFlow/subprocessors/1/recursiveSubFlow/subprocessors/1"), FlowTraceUtils.isFlowStackElement((String)"recursiveSubFlow", (String)"/recursiveSubFlowDynamic/processors/0/recursiveSubFlow/subprocessors/1/recursiveSubFlow/subprocessors/1"), FlowTraceUtils.isFlowStackElement((String)"recursiveSubFlow", (String)"/recursiveSubFlowDynamic/processors/0/recursiveSubFlow/subprocessors/1"), FlowTraceUtils.isFlowStackElement((String)"recursiveSubFlowDynamic", (String)"/recursiveSubFlowDynamic/processors/0")});
    }

    @Test
    public void subSubFlowDynamic() throws Exception {
        muleContext.getClient().send("vm://in-subSubFlowDynamic", (MuleMessage)new DefaultMuleMessage((Object)"1", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"/subSubFlowDynamic/processors/0/subFlowSubRef1/subprocessors/0/subFlow/subprocessors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowSubRef1", (String)"/subSubFlowDynamic/processors/0/subFlowSubRef1/subprocessors/0"), FlowTraceUtils.isFlowStackElement((String)"subSubFlowDynamic", (String)"/subSubFlowDynamic/processors/0")});
        muleContext.getClient().send("vm://in-subSubFlowDynamic", (MuleMessage)new DefaultMuleMessage((Object)"2", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"/subSubFlowDynamic/processors/0/subFlowSubRef2/subprocessors/0/subFlow/subprocessors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowSubRef2", (String)"/subSubFlowDynamic/processors/0/subFlowSubRef2/subprocessors/0"), FlowTraceUtils.isFlowStackElement((String)"subSubFlowDynamic", (String)"/subSubFlowDynamic/processors/0")});
    }

    @Test
    public void flowStaticWithAsync() throws Exception {
        muleContext.getClient().send("vm://in-flowStaticWithAsync", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        FlowTraceUtils.FlowStackAsyncAsserter.latch.await(1L, TimeUnit.SECONDS);
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flowInAsync", (String)"/flowInAsync/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowStaticWithAsync", (String)"/flowStaticWithAsync/processors/0/0")});
    }

    @Test
    public void subFlowStaticWithAsync() throws Exception {
        muleContext.getClient().send("vm://in-subFlowStaticWithAsync", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        FlowTraceUtils.FlowStackAsyncAsserter.latch.await(1L, TimeUnit.SECONDS);
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlowInAsync", (String)"/subFlowStaticWithAsync/processors/0/0/subFlowInAsync/subprocessors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowStaticWithAsync", (String)"/subFlowStaticWithAsync/processors/0/0")});
    }

    @Test
    public void flowDynamicWithAsync() throws Exception {
        muleContext.getClient().send("vm://in-flowDynamicWithAsync", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        FlowTraceUtils.FlowStackAsyncAsserter.latch.await(1L, TimeUnit.SECONDS);
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flowInAsync", (String)"/flowInAsync/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowDynamicWithAsync", (String)"/flowDynamicWithAsync/processors/0/0")});
    }

    @Test
    public void subFlowDynamicWithAsync() throws Exception {
        muleContext.getClient().send("vm://in-subFlowDynamicWithAsync", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        FlowTraceUtils.FlowStackAsyncAsserter.latch.await(1L, TimeUnit.SECONDS);
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlowInAsync", (String)"/subFlowDynamicWithAsync/processors/0/0/subFlowInAsync/subprocessors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowDynamicWithAsync", (String)"/subFlowDynamicWithAsync/processors/0/0")});
    }

    @Test
    public void flowStaticWithEnricher() throws Exception {
        muleContext.getClient().send("vm://in-flowStaticWithEnricher", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"/flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowStaticWithEnricher", (String)"/flowStaticWithEnricher/processors/0/0")});
    }

    @Test
    public void subFlowStaticWithEnricher() throws Exception {
        muleContext.getClient().send("vm://in-subFlowStaticWithEnricher", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"/subFlowStaticWithEnricher/processors/0/0/subFlow/subprocessors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowStaticWithEnricher", (String)"/subFlowStaticWithEnricher/processors/0")});
    }

    @Test
    public void flowDynamicWithEnricher() throws Exception {
        muleContext.getClient().send("vm://in-flowDynamicWithEnricher", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"/flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowDynamicWithEnricher", (String)"/flowDynamicWithEnricher/processors/0/0")});
    }

    @Test
    public void subFlowDynamicWithEnricher() throws Exception {
        muleContext.getClient().send("vm://in-subFlowDynamicWithEnricher", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"/subFlowDynamicWithEnricher/processors/0/0/subFlow/subprocessors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowDynamicWithEnricher", (String)"/subFlowDynamicWithEnricher/processors/0/0")});
    }

    @Test
    public void flowStaticWithChoice() throws Exception {
        muleContext.getClient().send("vm://in-flowStaticWithChoice", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"/flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowStaticWithChoice", (String)"/flowStaticWithChoice/processors/0/0/0")});
    }

    @Test
    public void subFlowStaticWithChoice() throws Exception {
        muleContext.getClient().send("vm://in-subFlowStaticWithChoice", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"/subFlowStaticWithChoice/processors/0/0/0/subFlow/subprocessors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowStaticWithChoice", (String)"/subFlowStaticWithChoice/processors/0/0/0")});
    }

    @Test
    public void flowDynamicWithChoice() throws Exception {
        muleContext.getClient().send("vm://in-flowDynamicWithChoice", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"/flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowDynamicWithChoice", (String)"/flowDynamicWithChoice/processors/0/0/0")});
    }

    @Test
    public void subFlowDynamicWithChoice() throws Exception {
        muleContext.getClient().send("vm://in-subFlowDynamicWithChoice", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"/subFlowDynamicWithChoice/processors/0/0/0/subFlow/subprocessors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowDynamicWithChoice", (String)"/subFlowDynamicWithChoice/processors/0/0/0")});
    }

    @Test
    public void recursiveSubFlowWithChoice() throws Exception {
        muleContext.getClient().send("vm://in-recursiveSubFlowWithChoice", (MuleMessage)new DefaultMuleMessage((Object)5, muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"/recursiveSubFlowWithChoice/processors/0/recursiveSubFlowChoice/subprocessors/1/1/0/subFlow/subprocessors/0"), FlowTraceUtils.isFlowStackElement((String)"recursiveSubFlowChoice", (String)"/recursiveSubFlowWithChoice/processors/0/recursiveSubFlowChoice/subprocessors/1/1/0"), FlowTraceUtils.isFlowStackElement((String)"recursiveSubFlowWithChoice", (String)"/recursiveSubFlowWithChoice/processors/0")});
    }

    @Test
    public void flowStaticWithScatterGather() throws Exception {
        muleContext.getClient().send("vm://in-flowStaticWithScatterGather", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"/flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowStaticWithScatterGather", (String)"/flowStaticWithScatterGather/processors/0/1/0")});
    }

    @Test
    public void subFlowStaticWithScatterGather() throws Exception {
        muleContext.getClient().send("vm://in-subFlowStaticWithScatterGather", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"/subFlowStaticWithScatterGather/processors/0/1/subFlow/subprocessors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowStaticWithScatterGather", (String)"/subFlowStaticWithScatterGather/processors/0/1")});
    }

    @Test
    public void flowDynamicWithScatterGather() throws Exception {
        muleContext.getClient().send("vm://in-flowDynamicWithScatterGather", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"/flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowDynamicWithScatterGather", (String)"/flowDynamicWithScatterGather/processors/0/1/0")});
    }

    @Test
    public void subFlowDynamicWithScatterGather() throws Exception {
        muleContext.getClient().send("vm://in-subFlowDynamicWithScatterGather", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"/subFlowDynamicWithScatterGather/processors/0/1/0/subFlow/subprocessors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowDynamicWithScatterGather", (String)"/subFlowDynamicWithScatterGather/processors/0/1/0")});
    }

    @Test
    public void flowStaticWithScatterGatherChain() throws Exception {
        muleContext.getClient().send("vm://in-flowStaticWithScatterGatherChain", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"/flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowStaticWithScatterGatherChain", (String)"/flowStaticWithScatterGatherChain/processors/0/1/0")});
    }

    @Test
    public void subFlowStaticWithScatterGatherChain() throws Exception {
        muleContext.getClient().send("vm://in-subFlowStaticWithScatterGatherChain", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"/subFlowStaticWithScatterGatherChain/processors/0/1/0/subFlow/subprocessors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowStaticWithScatterGatherChain", (String)"/subFlowStaticWithScatterGatherChain/processors/0/1/0")});
    }

    @Test
    public void flowDynamicWithScatterGatherChain() throws Exception {
        muleContext.getClient().send("vm://in-flowDynamicWithScatterGatherChain", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"/flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowDynamicWithScatterGatherChain", (String)"/flowDynamicWithScatterGatherChain/processors/0/1/0")});
    }

    @Test
    public void subFlowDynamicWithScatterGatherChain() throws Exception {
        muleContext.getClient().send("vm://in-subFlowDynamicWithScatterGatherChain", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"/subFlowDynamicWithScatterGatherChain/processors/0/1/0/subFlow/subprocessors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowDynamicWithScatterGatherChain", (String)"/subFlowDynamicWithScatterGatherChain/processors/0/1/0")});
    }

    @Test
    public void flowChainedFilter() throws Exception {
        muleContext.getClient().send("vm://in-flowChainedFilter", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"/flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowChainedFilter", (String)"/flowChainedFilter/processors/0/1")});
    }

    @Test
    public void flowChainedFilterManyProcessors() throws Exception {
        muleContext.getClient().send("vm://in-flowChainedFilterManyProcessors", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"/flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowChainedFilterManyProcessors", (String)"/flowChainedFilterManyProcessors/processors/0/2")});
    }

    @Test
    public void flowUnacceptedMessageFilterUnaccepted() throws Exception {
        muleContext.getClient().send("vm://in-flowStaticWithMessageFilterUnaccepted", (MuleMessage)new DefaultMuleMessage(null, muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"/flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowStaticWithMessageFilterUnaccepted", (String)"/flowStaticWithMessageFilterUnaccepted/processors/0")});
    }

    @Test
    public void subFlowUnacceptedMessageFilterUnaccepted() throws Exception {
        muleContext.getClient().send("vm://in-subFlowStaticWithMessageFilterUnaccepted", (MuleMessage)new DefaultMuleMessage(null, muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"/subFlowStaticWithMessageFilterUnaccepted/processors/0/0/subFlow/subprocessors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowStaticWithMessageFilterUnaccepted", (String)"/subFlowStaticWithMessageFilterUnaccepted/processors/0")});
    }

    @Test
    public void flowForEach() throws Exception {
        muleContext.getClient().send("vm://in-flowForEach", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"/flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowForEach", (String)"/flowForEach/processors/0/1")});
    }

    @Test
    public void flowForEachRepeatedInterceptingMessageProcessor() throws Exception {
        muleContext.getClient().send("vm://in-flowForEachRepeatedInterceptingMessageProcessor", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"/flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowForEachRepeatedInterceptingMessageProcessor", (String)"/flowForEachRepeatedInterceptingMessageProcessor/processors/0/3")});
    }

    @Test
    public void flowForEachFilter() throws Exception {
        muleContext.getClient().send("vm://in-flowForEachFilter", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"/flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowForEachFilter", (String)"/flowForEachFilter/processors/0/1")});
    }
}

