/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification.processors;

import java.util.LinkedHashSet;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.Pipeline;
import org.mule.api.processor.DefaultMessageProcessorPathElement;
import org.mule.api.processor.MessageProcessorPathElement;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.NotificationUtils;

public class MessageProcessorNotificationPathTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/notifications/message-processor-notification-test-flow.xml";
    }

    @Test
    public void components() throws Exception {
        this.testFlowPaths("singleMP", "/0");
        this.testFlowPaths("singleMP2", "/0", "/1");
        this.testFlowPaths("singleMP3", "/0", "/1", "/2");
        this.testFlowPaths("processorChain2", "/0", "/0/0", "/0/1", "/0/2");
        this.testFlowPaths("processorChain3", "/0", "/0/0", "/0/1");
        this.testFlowPaths("processorChain4", "/0", "/0/0", "/0/1", "/1");
        this.testFlowPaths("processorChain", "/0", "/0/0", "/0/1");
        this.testFlowPaths("customProcessor", "/0", "/1");
    }

    @Test
    public void routers() throws Exception {
        this.testFlowPaths("choice", "/0", "/0/0", "/0/0/0", "/0/1", "/0/1/0", "/0/2", "/0/2/0");
        this.testFlowPaths("all2", "/0", "/0/0", "/0/0/0", "/0/0/1", "/0/1", "/0/1/0", "/0/1/1", "/1");
        this.testFlowPaths("choice2", "/0", "/0/0", "/0/0/0", "/0/0/1", "/0/1", "/0/1/0", "/0/2", "/0/2/0", "/0/2/1");
        this.testFlowPaths("all", "/0", "/0/0", "/0/0/0", "/0/1", "/0/1/0", "/1");
        this.testFlowPaths("scatterGather", "/0", "/0/0", "/0/0/0", "/0/1", "/0/1/0", "/0/1/1");
    }

    @Test
    public void interceptors() throws Exception {
        this.testFlowPaths("cxfMP", "/0", "/1", "/2");
    }

    @Test
    public void scopes() throws Exception {
        this.testFlowPaths("foreach", "/0", "/0/0", "/1");
        this.testFlowPaths("enricher", "/0", "/0/0", "/1", "/1/0", "/1/0/0", "/1/0/1");
        this.testFlowPaths("until-successful", "/0", "/0/0", "/1");
        this.testFlowPaths("until-successful-with-processor-chain", "/0", "/0/0", "/0/0/0", "/0/0/1", "/1");
        this.testFlowPaths("until-successful-with-enricher", "/0", "/0/0", "/0/0/0", "/1");
        this.testFlowPaths("async", "/0", "/0/0", "/0/1");
        this.testFlowPaths("single-transaction", "/0", "/0/0", "/0/1");
        this.testFlowPaths("single-transaction-not-first-element", "/0", "/1", "/1/0", "/1/1");
    }

    @Test
    public void filters() throws Exception {
        this.testFlowPaths("filters", "/0", "/1");
        this.testFlowPaths("idempotent-msg-filter", "/0", "/1");
        this.testFlowPaths("idempotent-secure-hash-msg-filter", "/0", "/1");
    }

    @Test
    public void flowRefs() throws Exception {
        this.testFlowPaths("subflow", "/0", "/1", "/1/subflow-call/subprocessors/0", "/1/subflow-call/subprocessors/1");
        this.testFlowPaths("subflow2", "/0", "/1", "/1/subflow-call/subprocessors/0", "/1/subflow-call/subprocessors/1", "/2");
        this.testFlowPaths("subflow\\/With\\/Slash", "/0", "/1", "/1/subflow\\/call/subprocessors/0", "/1/subflow\\/call/subprocessors/1", "/2");
    }

    @Test
    public void exceptionStrategies() throws Exception {
        this.testFlowPaths("catch-es", "/0", "es/0");
        this.testFlowPaths("rollback-es", "/0", "es/0", "es/1");
        this.testFlowPaths("choice-es", "/0", "es/0/0", "es/0/1", "es/1/0");
        this.testFlowPaths("global-es", "/0", "Global_Exception_Strategy/es/0", "Global_Exception_Strategy/es/1");
    }

    @Test
    public void requestReply() throws Exception {
        this.testFlowPaths("request-reply", "/0", "/1");
    }

    @Test
    public void multipleEndpoints() throws Exception {
        this.testFlowPaths("composite-source", "/0");
        this.testFlowPaths("first-successful", "/0", "/1", "/1/0", "/1/1", "/1/2", "/1/3");
        this.testFlowPaths("round-robin", "/0", "/0/0", "/0/1", "/0/2", "/1");
    }

    @Test
    public void collections() throws Exception {
        this.testFlowPaths("collectionAggregator", "/0", "/1", "/2");
        this.testFlowPaths("customAggregator", "/0", "/1", "/2");
        this.testFlowPaths("chunkAggregator", "/0", "/1", "/2", "/3");
        this.testFlowPaths("combineCollections", "/0", "/1");
    }

    @Test
    public void wireTap() throws Exception {
        this.testFlowPaths("wire-tap", "/0", "/0/0", "/1");
    }

    private void testFlowPaths(String flowName, String ... nodes) throws Exception {
        Object[] expectedPaths = this.generatePaths(flowName, nodes);
        FlowConstruct flow = this.getFlowConstruct(this.unescape(flowName));
        DefaultMessageProcessorPathElement flowElement = new DefaultMessageProcessorPathElement(null, flowName);
        ((Pipeline)flow).addMessageProcessorPathElements((MessageProcessorPathElement)flowElement);
        NotificationUtils.FlowMap messageProcessorPaths = NotificationUtils.buildPathResolver((MessageProcessorPathElement)flowElement);
        Assert.assertThat((Object)messageProcessorPaths.getAllPaths(), (Matcher)IsCollectionWithSize.hasSize((int)nodes.length));
        Assert.assertThat((Object)messageProcessorPaths.getAllPaths(), (Matcher)IsCollectionContaining.hasItems((Object[])expectedPaths));
    }

    private String[] generatePaths(String flowName, String[] nodes) {
        LinkedHashSet<String> pathSet = new LinkedHashSet<String>();
        String base = "/" + flowName + "/processors";
        for (String node : nodes) {
            if (!node.startsWith("/")) {
                base = "/" + flowName + "/";
            }
            pathSet.add(base + node);
        }
        return pathSet.toArray(new String[0]);
    }

    private String unescape(String name) {
        StringBuilder builder = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i < name.length() - 1 && name.charAt(i + 1) == '/') {
                builder.append("/");
                ++i;
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }
}

