/*
 * Decompiled with CFR 0.152.
 */
package org.mule.issues;

import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.IOUtils;

public class Mule18493TestCase
extends FunctionalTestCase {
    private static final int DEFAULT_TIMEOUT = 1000;
    public static final String SOAP_REQUEST_BODY = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:test=\"http://test.Pablo.name/\"><soapenv:Header/><soapenv:Body><test:Hi/></soapenv:Body></soapenv:Envelope>";
    public static final String EXPECTED_RESPONSE_BODY = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><test:Hi xmlns:test=\"http://test.Pablo.name/\"/></soap:Body></soap:Envelope>";
    @Rule
    public DynamicPort listenPort = new DynamicPort("port");

    protected HttpVersion getHttpVersion() {
        return HttpVersion.HTTP_1_0;
    }

    protected String getUrl(String path) {
        return String.format("http://localhost:%s/%s", this.listenPort.getNumber(), path);
    }

    protected String getConfigFile() {
        return "cxf-proxy-service-http-10.xml";
    }

    @Test
    public void cxfOutputHandler() throws Exception {
        String url = this.getUrl("cxfOutputHandlerFlow");
        Response response = Request.Post((String)url).version(this.getHttpVersion()).connectTimeout(1000).socketTimeout(1000).bodyByteArray(SOAP_REQUEST_BODY.getBytes()).execute();
        HttpResponse httpResponse = response.returnResponse();
        Header transferEncodingHeader = httpResponse.getFirstHeader("Transfer-Encoding");
        Assert.assertThat((Object)transferEncodingHeader, (Matcher)CoreMatchers.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)CoreMatchers.is((Object)EXPECTED_RESPONSE_BODY));
    }
}

